/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha.ai;

import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;

public class EntityAIMoveToBlock
extends EntityAIBase {
    private final EntityCreature entity;
    protected WorldCoordinate watchedBlock;
    private final int maxDist;
    private final float weight;
    private final Block searchedBlock;
    private final int searchedMeta;

    public EntityAIMoveToBlock(EntityCreature entity, Block searchedBlock, int searchedMeta, int maxDist) {
        this(entity, searchedBlock, searchedMeta, maxDist, 0.001f);
    }

    public EntityAIMoveToBlock(EntityCreature entity, Block searchedBlock, int searchedMeta, int maxDist, float weight) {
        this.entity = entity;
        this.searchedBlock = searchedBlock;
        this.searchedMeta = searchedMeta;
        this.maxDist = maxDist;
        this.weight = weight;
        this.setMutexBits(1);
    }

    public boolean shouldExecute() {
        if (this.entity.getRNG().nextFloat() >= this.weight) {
            return false;
        }
        if (!this.entity.worldObj.isDaytime()) {
            return false;
        }
        if (this.watchedBlock == null || !this.isBlockValid()) {
            this.watchedBlock = WorldPlugin.findBlock(this.entity.worldObj, (int)this.entity.posX, (int)this.entity.posY, (int)this.entity.posZ, this.maxDist, this.searchedBlock, this.searchedMeta);
        }
        return this.watchedBlock != null;
    }

    private boolean isBlockValid() {
        if (this.searchedBlock != WorldPlugin.getBlock((IBlockAccess)this.entity.worldObj, this.watchedBlock)) {
            return false;
        }
        return WorldPlugin.getDistanceSq(this.watchedBlock, this.entity.posX, this.entity.posY, this.entity.posZ) <= (double)(this.maxDist * this.maxDist);
    }

    public boolean continueExecuting() {
        return !this.entity.getNavigator().noPath();
    }

    public void startExecuting() {
        if (this.entity.getDistanceSq((double)this.watchedBlock.x + 0.5, (double)this.watchedBlock.y + 0.5, (double)this.watchedBlock.z + 0.5) > 256.0) {
            Vec3 vec3 = RandomPositionGenerator.findRandomTargetBlockTowards((EntityCreature)this.entity, (int)14, (int)3, (Vec3)Vec3.createVectorHelper((double)((double)this.watchedBlock.x + 0.5), (double)((double)this.watchedBlock.y + 0.5), (double)((double)this.watchedBlock.z + 0.5)));
            if (vec3 != null) {
                this.move(vec3.xCoord, vec3.yCoord, vec3.zCoord);
            }
        } else {
            this.move((double)this.watchedBlock.x + 0.5, (double)this.watchedBlock.y + 0.5, (double)this.watchedBlock.z + 0.5);
        }
    }

    private void move(double x, double y, double z) {
        this.entity.getNavigator().tryMoveToXYZ(x, y, z, 0.6);
    }

    public void resetTask() {
        this.watchedBlock = null;
    }
}

