/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineItem;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.alpha.ai.EntityAIMoveToBlock;
import mods.railcraft.common.blocks.machine.alpha.ai.EntityAIWatchBlock;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.AIPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.PhantomInventory;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.common.util.ForgeDirection;

public class TileTradeStation
extends TileMachineItem
implements IGuiReturnHandler,
ISidedInventory {
    private static final int AREA = 6;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 16);
    private int profession;
    private final PhantomInventory recipeSlots = new PhantomInventory(9);
    private final InventoryMapper invInput;
    private final InventoryMapper invOutput;
    protected ForgeDirection direction = ForgeDirection.NORTH;

    public TileTradeStation() {
        this.setInventorySize(16);
        this.invInput = new InventoryMapper(this, 0, 10);
        this.invOutput = new InventoryMapper(this, 10, 6, false);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.TRADE_STATION;
    }

    @Override
    public IIcon getIcon(int side) {
        if (side == this.direction.ordinal()) {
            return this.getMachineType().getTexture(4);
        }
        if (side < 2) {
            return this.getMachineType().getTexture(0);
        }
        return this.getMachineType().getTexture(2);
    }

    public IInventory getRecipeSlots() {
        return this.recipeSlots;
    }

    public int getProfession() {
        return this.profession;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.TRADE_STATION, player, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        return true;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.clock % 256 == 0) {
            this.modifyNearbyAI();
        }
        List<EntityVillager> villagers = MiscTools.getNearbyEntities(this.worldObj, EntityVillager.class, this.xCoord, this.yCoord - 1, this.yCoord + 3, this.zCoord, 6.0f);
        this.attemptTrade(villagers, 0);
        this.attemptTrade(villagers, 1);
        this.attemptTrade(villagers, 2);
    }

    private void modifyNearbyAI() {
        List<EntityVillager> villagers = MiscTools.getNearbyEntities(this.worldObj, EntityVillager.class, this.xCoord, this.yCoord - 1, this.yCoord + 3, this.zCoord, 20.0f);
        for (EntityVillager villager : villagers) {
            AIPlugin.addAITask((EntityLiving)villager, 9, new EntityAIWatchBlock((EntityLiving)villager, this.getMachineType().getBlock(), this.getMachineType().ordinal(), 4, 0.08f));
            AIPlugin.addAITask((EntityLiving)villager, 9, new EntityAIMoveToBlock((EntityCreature)villager, this.getMachineType().getBlock(), this.getMachineType().ordinal(), 16, 0.002f));
        }
    }

    private boolean attemptTrade(List<EntityVillager> villagers, int tradeSet) {
        ItemStack buy1 = this.recipeSlots.getStackInSlot(tradeSet * 3 + 0);
        ItemStack buy2 = this.recipeSlots.getStackInSlot(tradeSet * 3 + 1);
        ItemStack sell = this.recipeSlots.getStackInSlot(tradeSet * 3 + 2);
        for (EntityVillager villager : villagers) {
            MerchantRecipeList recipes = villager.getRecipes(null);
            for (MerchantRecipe recipe : recipes) {
                if (recipe.isRecipeDisabled() || recipe.getItemToBuy() != null && !InvTools.isItemLessThanOrEqualTo(recipe.getItemToBuy(), buy1) || recipe.getSecondItemToBuy() != null && !InvTools.isItemLessThanOrEqualTo(recipe.getSecondItemToBuy(), buy2) || !InvTools.isItemGreaterOrEqualThan(recipe.getItemToSell(), sell) || !this.canDoTrade(recipe)) continue;
                this.doTrade((IMerchant)villager, recipe);
                return true;
            }
        }
        return false;
    }

    private boolean canDoTrade(MerchantRecipe recipe) {
        if (recipe.getItemToBuy() != null && InvTools.countItems((IInventory)this.invInput, recipe.getItemToBuy()) < recipe.getItemToBuy().stackSize) {
            return false;
        }
        if (recipe.getSecondItemToBuy() != null && InvTools.countItems((IInventory)this.invInput, recipe.getSecondItemToBuy()) < recipe.getSecondItemToBuy().stackSize) {
            return false;
        }
        return InvTools.isRoomForStack(recipe.getItemToSell(), this.invOutput);
    }

    private void doTrade(IMerchant merchant, MerchantRecipe recipe) {
        merchant.useRecipe(recipe);
        if (recipe.getItemToBuy() != null) {
            InvTools.removeItemsAbsolute((IInventory)this.invInput, recipe.getItemToBuy().stackSize, recipe.getItemToBuy());
        }
        if (recipe.getSecondItemToBuy() != null) {
            InvTools.removeItemsAbsolute((IInventory)this.invInput, recipe.getSecondItemToBuy().stackSize, recipe.getSecondItemToBuy());
        }
        InvTools.moveItemStack(recipe.getItemToSell().copy(), this.invOutput);
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(entityliving, stack);
        this.direction = MiscTools.getSideClosestToPlayer(this.worldObj, this.xCoord, this.yCoord, this.zCoord, entityliving);
    }

    @Override
    public boolean rotateBlock(ForgeDirection axis) {
        this.direction = this.direction == axis ? axis.getOpposite() : axis;
        this.markBlockForUpdate();
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.recipeSlots.writeToNBT("recipe", data);
        data.setInteger("profession", this.profession);
        data.setByte("direction", (byte)this.direction.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.recipeSlots.readFromNBT("recipe", data);
        this.profession = data.getInteger("profession");
        this.direction = ForgeDirection.getOrientation((int)data.getByte("direction"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeInt(this.profession);
        data.writeByte(this.direction.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.profession = data.readInt();
        ForgeDirection f = ForgeDirection.getOrientation((int)data.readByte());
        if (this.direction != f) {
            this.direction = f;
            this.markBlockForUpdate();
        }
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        GuiPacketType type = GuiPacketType.values()[data.readByte()];
        switch (type) {
            case NEXT_TRADE: {
                this.nextTrade(data.readByte());
                break;
            }
            case SET_PROFESSION: {
                this.profession = data.readInt();
                this.sendUpdateToClient();
            }
        }
    }

    public void nextTrade(int tradeSet) {
        EntityVillager villager = new EntityVillager(this.worldObj);
        villager.setProfession(this.profession);
        MerchantRecipeList recipes = villager.getRecipes(null);
        MerchantRecipe recipe = (MerchantRecipe)recipes.get(MiscTools.RANDOM.nextInt(recipes.size()));
        this.recipeSlots.setInventorySlotContents(tradeSet * 3 + 0, recipe.getItemToBuy());
        this.recipeSlots.setInventorySlotContents(tradeSet * 3 + 1, recipe.getSecondItemToBuy());
        this.recipeSlots.setInventorySlotContents(tradeSet * 3 + 2, recipe.getItemToSell());
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return slot < 10;
    }

    public int[] getAccessibleSlotsFromSide(int var1) {
        return SLOTS;
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        return this.isItemValidForSlot(slot, stack);
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return slot >= 10;
    }

    public static enum GuiPacketType {
        NEXT_TRADE,
        SET_PROFESSION;

    }
}

