/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.TileTank;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.FluidItemHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.fluids.tanks.FilteredTank;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.gui.slots.SlotWaterOrEmpty;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.ITileFilter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class TileTankWater
extends TileTank
implements ISidedInventory {
    private static final int OUTPUT_RATE = 40;
    private static final int TANK_CAPACITY = 400000;
    private static final int REFILL_INTERVAL = 8;
    private static final float REFILL_RATE = 10.0f;
    private static final float REFILL_PENALTY_INSIDE = 0.5f;
    private static final float REFILL_PENALTY_SNOW = 0.5f;
    private static final float REFILL_BOOST_RAIN = 3.0f;
    private static final byte REFILL_RATE_MIN = 1;
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_OUTPUT = 1;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 2);
    private static final ForgeDirection[] LIQUID_OUTPUTS = new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.SOUTH};
    private static final ITileFilter LIQUID_OUTPUT_FILTER = new ITileFilter(){

        @Override
        public boolean matches(TileEntity tile) {
            if (tile instanceof TileTank) {
                return false;
            }
            return tile instanceof IFluidHandler;
        }
    };
    private static final List<MultiBlockPattern> patterns = new ArrayList<MultiBlockPattern>();
    private final FilteredTank tank;
    private IInventory invInput = new InventoryMapper(this, 0, 1);
    private IInventory invOutput = new InventoryMapper(this, 1, 1);

    public TileTankWater() {
        super("gui.tank.water", 2, patterns);
        this.tank = new FilteredTank(400000, Fluids.WATER.get(), this);
        this.tankManager.add(this.tank);
    }

    public static void placeWaterTank(World world, int x, int y, int z, int water) {
        Iterator<MultiBlockPattern> iterator = patterns.iterator();
        if (iterator.hasNext()) {
            MultiBlockPattern pattern = iterator.next();
            HashMap<Character, Integer> blockMapping = new HashMap<Character, Integer>();
            blockMapping.put(Character.valueOf('B'), EnumMachineAlpha.TANK_WATER.ordinal());
            TileEntity tile = pattern.placeStructure(world, x, y, z, RailcraftBlocks.getBlockMachineAlpha(), blockMapping);
            if (tile instanceof TileTankWater) {
                TileTankWater master = (TileTankWater)tile;
                master.tank.setFluid(Fluids.WATER.get(water));
            }
            return;
        }
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.TANK_WATER;
    }

    @Override
    public String getTitle() {
        return LocalizationPlugin.translate("railcraft.gui.tank.water");
    }

    @Override
    public Slot getInputSlot(IInventory inv, int id, int x, int y) {
        return new SlotWaterOrEmpty(inv, id, x, y);
    }

    @Override
    public boolean blockActivated(EntityPlayer player, int side) {
        if (Game.isHost(this.worldObj) ? this.isStructureValid() && FluidHelper.handleRightClick(this.getTankManager(), ForgeDirection.getOrientation((int)side), player, true, true) : FluidItemHelper.isContainer(player.inventory.getCurrentItem())) {
            return true;
        }
        return super.blockActivated(player, side);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isHost(this.getWorld())) {
            TankManager tMan;
            if (this.isMaster()) {
                if (this.worldObj.provider.dimensionId != -1 && this.clock % 8 == 0) {
                    float rate = 10.0f;
                    BiomeGenBase biome = this.worldObj.getBiomeGenForCoords(this.xCoord, this.zCoord);
                    float humidity = biome.rainfall;
                    rate *= humidity;
                    boolean outside = false;
                    for (int x = this.xCoord - 1; x <= this.xCoord + 1; ++x) {
                        for (int z = this.zCoord - 1; z <= this.zCoord + 1 && !(outside = this.worldObj.canBlockSeeTheSky(x, this.yCoord + 3, z)); ++z) {
                        }
                    }
                    if (!outside) {
                        rate *= 0.5f;
                    } else if (this.worldObj.isRaining()) {
                        rate = biome.getEnableSnow() ? (rate *= 0.5f) : (rate *= 3.0f);
                    }
                    int rateFinal = MathHelper.floor_float((float)rate);
                    if (rateFinal < 1) {
                        rateFinal = 1;
                    }
                    FluidStack fillStack = Fluids.WATER.get(rateFinal);
                    this.fill(ForgeDirection.UP, fillStack, true);
                }
                if (this.clock % 8 == 0) {
                    FluidHelper.processContainers(this.tankManager.get(0), this, 0, 1);
                }
            }
            if ((tMan = this.getTankManager()) != null) {
                tMan.outputLiquid(this.tileCache, LIQUID_OUTPUT_FILTER, LIQUID_OUTPUTS, 0, 40);
            }
        }
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        TileMultiBlock mBlock = this.getMasterBlock();
        if (mBlock != null) {
            GuiHandler.openGui(EnumGui.TANK, player, this.worldObj, mBlock.xCoord, mBlock.yCoord, mBlock.zCoord);
            return true;
        }
        return false;
    }

    @Override
    public IIcon getIcon(int side) {
        return EnumMachineAlpha.TANK_WATER.getTexture(side);
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (from != ForgeDirection.UP || resource == null || !Fluids.WATER.is(resource)) {
            return 0;
        }
        return super.fill(from, resource, doFill);
    }

    @Override
    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !Fluids.WATER.is(resource)) {
            return null;
        }
        return super.drain(from, resource.amount, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from == ForgeDirection.UP && Fluids.WATER.is(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from != ForgeDirection.UP && Fluids.WATER.is(fluid);
    }

    @Override
    public int[] getAccessibleSlotsFromSide(int side) {
        return SLOTS;
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        return this.isItemValidForSlot(slot, stack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (!super.isItemValidForSlot(slot, stack)) {
            return false;
        }
        switch (slot) {
            case 0: {
                return FluidItemHelper.isRoomInContainer(stack, Fluids.WATER.get()) || FluidItemHelper.containsFluid(stack, Fluids.WATER.get());
            }
        }
        return false;
    }

    static {
        char[][][] map = new char[][][]{new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'A', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map, 2, 1, 2));
    }
}

