/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.fluids.tanks.FilteredTank;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.misc.RailcraftDamageSource;
import mods.railcraft.common.util.sounds.SoundHelper;
import mods.railcraft.common.util.steam.ISteamUser;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class TileSteamTrap
extends TileMachineBase
implements IFluidHandler,
ISteamUser {
    private static final byte JET_TIME = 40;
    private static final byte DAMAGE = 8;
    private static final double RANGE = 3.5;
    protected ForgeDirection direction = ForgeDirection.NORTH;
    protected boolean powered;
    private byte jet;
    private final TankManager tankManager = new TankManager();
    private final FilteredTank tank = new FilteredTank(32000, Fluids.STEAM.get());

    public TileSteamTrap() {
        this.tankManager.add(this.tank);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.jet > 0) {
            this.jet = (byte)(this.jet - 1);
            if (this.jet == 0) {
                this.sendUpdateToClient();
            }
        }
        if (Game.isNotHost(this.worldObj)) {
            if (this.isJetting()) {
                double speedFactor = 0.2;
                for (int i = 0; i < 10; ++i) {
                    EffectManager.instance.steamJetEffect(this.worldObj, this, (double)this.direction.offsetX * speedFactor, (double)this.direction.offsetY * speedFactor, (double)this.direction.offsetZ * speedFactor);
                }
            }
            return;
        }
        this.triggerCheck();
        if (this.isJetting()) {
            for (EntityLivingBase entity : this.getEntitiesInSteamArea()) {
                entity.attackEntityFrom((DamageSource)RailcraftDamageSource.STEAM, 8.0f);
            }
        }
    }

    public List<EntityLivingBase> getEntitiesInSteamArea() {
        AxisAlignedBB area = AxisAlignedBB.getBoundingBox((double)-0.5, (double)-0.5, (double)-0.5, (double)0.5, (double)0.5, (double)0.5);
        MiscTools.addCoordToAABB(area, (double)this.direction.offsetX * 3.5, (double)this.direction.offsetY * 3.5, (double)this.direction.offsetZ * 3.5);
        area.offset((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5);
        List entities = this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, area);
        return entities;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(0, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == null || Fluids.STEAM.is(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection direction) {
        return this.tankManager.getTankInfo(direction);
    }

    protected abstract void triggerCheck();

    protected void jet() {
        if (!this.canJet()) {
            return;
        }
        this.jet = (byte)40;
        this.tank.setFluid(null);
        SoundHelper.playSound(this.worldObj, this.xCoord, this.yCoord, this.zCoord, "railcraft:machine.steamhiss", 1.0f, (float)(1.0 + MiscTools.getRand().nextGaussian() * 0.1));
        this.sendUpdateToClient();
    }

    public boolean isJetting() {
        return this.jet > 0;
    }

    public void onStopJetting() {
    }

    public boolean canJet() {
        return !this.isJetting() && this.tank.isFull();
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(entityliving, stack);
        this.direction = MiscTools.getSideClosestToPlayer(this.worldObj, this.xCoord, this.yCoord, this.zCoord, entityliving);
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        this.powered = PowerPlugin.isBlockBeingPowered(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public boolean rotateBlock(ForgeDirection axis) {
        this.direction = this.direction == axis ? axis.getOpposite() : axis;
        this.markBlockForUpdate();
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setByte("direction", (byte)this.direction.ordinal());
        data.setBoolean("powered", this.powered);
        this.tankManager.writeTanksToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.direction = ForgeDirection.getOrientation((int)data.getByte("direction"));
        this.powered = data.getBoolean("powered");
        this.tankManager.readTanksFromNBT(data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.jet);
        data.writeByte(this.direction.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.jet = data.readByte();
        this.direction = ForgeDirection.getOrientation((int)data.readByte());
        this.markBlockForUpdate();
    }
}

