/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileSmoker
extends TileMachineBase {
    private static final int SNOW_MELT_INTERVAL = 32;
    private static final Random rand = MiscTools.getRand();
    private boolean powered;

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.SMOKER;
    }

    @Override
    public IIcon getIcon(int side) {
        return this.getMachineType().getTexture(side);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.powered) {
            if (Game.isHost(this.worldObj)) {
                Block blockAbove;
                if (this.clock % 32 == 0 && (blockAbove = WorldPlugin.getBlock((IBlockAccess)this.worldObj, this.xCoord, this.yCoord + 1, this.zCoord)) == Blocks.snow_layer) {
                    WorldPlugin.setBlockToAir(this.worldObj, this.xCoord, this.yCoord + 1, this.zCoord);
                }
            } else {
                if (!WorldPlugin.blockIsAir(this.worldObj, this.xCoord, this.yCoord + 1, this.zCoord)) {
                    return;
                }
                double px = (float)this.xCoord + rand.nextFloat();
                double py = (float)this.yCoord + rand.nextFloat() * 0.5f + 1.0f;
                double pz = (float)this.zCoord + rand.nextFloat();
                EffectManager.instance.chimneyEffect(this.worldObj, px, py, pz);
            }
        }
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        this.powered = PowerPlugin.isBlockBeingPowered(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        this.sendUpdateToClient();
    }

    @Override
    public boolean isSideSolid(ForgeDirection side) {
        return side != ForgeDirection.UP;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.powered = data.getBoolean("powered");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setBoolean("powered", this.powered);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
    }
}

