/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import buildcraft.api.statements.IActionExternal;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.buildcraft.actions.Actions;
import mods.railcraft.common.plugins.buildcraft.triggers.IHasWork;
import mods.railcraft.common.util.crafting.RollingMachineCraftingManager;
import mods.railcraft.common.util.inventory.AdjacentInventoryCache;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.InventoryConcatenator;
import mods.railcraft.common.util.inventory.InventorySorter;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import mods.railcraft.common.util.inventory.filters.ArrayStackFilter;
import mods.railcraft.common.util.inventory.wrappers.IInvSlot;
import mods.railcraft.common.util.inventory.wrappers.InventoryIterator;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TileRollingMachine
extends TileMachineBase
implements IEnergyHandler,
ISidedInventory,
IHasWork {
    private static final int PROCESS_TIME = 100;
    private static final int ACTIVATION_POWER = 50;
    private static final int MAX_RECEIVE = 1000;
    private static final int MAX_ENERGY = 5000;
    private static final int SLOT_RESULT = 0;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 10);
    private final InventoryCrafting craftMatrix = new InventoryCrafting((Container)new RollingContainer(), 3, 3);
    private final StandaloneInventory invResult = new StandaloneInventory(1, "invResult", (IInventory)this);
    private final IInventory inv = InventoryConcatenator.make().add(this.invResult).add((IInventory)this.craftMatrix);
    private EnergyStorage energyStorage;
    public boolean useLast;
    private boolean isWorking;
    private boolean paused;
    private ItemStack currentReceipe;
    private int progress;
    private final AdjacentInventoryCache cache = new AdjacentInventoryCache(this, this.tileCache, null, InventorySorter.SIZE_DECENDING);
    private final Set<IActionExternal> actions = new HashSet<IActionExternal>();

    public TileRollingMachine() {
        if (RailcraftConfig.machinesRequirePower()) {
            this.energyStorage = new EnergyStorage(5000, 1000);
        }
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.ROLLING_MACHINE;
    }

    @Override
    public IIcon getIcon(int side) {
        return this.getMachineType().getTexture(side);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setInteger("progress", this.progress);
        if (this.energyStorage != null) {
            this.energyStorage.writeToNBT(data);
        }
        this.invResult.writeToNBT("invResult", data);
        InvTools.writeInvToNBT((IInventory)this.craftMatrix, "Crafting", data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.progress = data.getInteger("progress");
        if (this.energyStorage != null) {
            this.energyStorage.readFromNBT(data);
        }
        this.invResult.readFromNBT("invResult", data);
        InvTools.readInvFromNBT((IInventory)this.craftMatrix, "Crafting", data);
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        if (player.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) > 64.0) {
            return false;
        }
        GuiHandler.openGui(EnumGui.ROLLING_MACHINE, player, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        return true;
    }

    public void markDirty() {
        this.craftMatrix.markDirty();
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        InvTools.dropInventory(this.inv, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 100;
    }

    public InventoryCrafting getCraftMatrix() {
        return this.craftMatrix;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isNotHost(this.worldObj)) {
            return;
        }
        this.balanceSlots();
        if (this.clock % 16 == 0) {
            this.processActions();
        }
        if (this.paused) {
            return;
        }
        if (this.clock % 8 == 0) {
            this.currentReceipe = RollingMachineCraftingManager.getInstance().findMatchingRecipe(this.craftMatrix, this.worldObj);
            if (this.currentReceipe != null) {
                this.findMoreStuff();
            }
        }
        if (this.currentReceipe != null && this.canMakeMore()) {
            if (this.progress >= 100) {
                this.isWorking = false;
                if (InvTools.isRoomForStack(this.currentReceipe, this.invResult)) {
                    this.currentReceipe = RollingMachineCraftingManager.getInstance().findMatchingRecipe(this.craftMatrix, this.worldObj);
                    if (this.currentReceipe != null) {
                        for (int i = 0; i < this.craftMatrix.getSizeInventory(); ++i) {
                            this.craftMatrix.decrStackSize(i, 1);
                        }
                        InvTools.moveItemStack(this.currentReceipe, this.invResult);
                    }
                    this.useLast = false;
                    this.progress = 0;
                }
            } else {
                this.isWorking = true;
                if (this.energyStorage != null) {
                    int energy = this.energyStorage.extractEnergy(50, true);
                    if (energy >= 50) {
                        ++this.progress;
                        this.energyStorage.extractEnergy(50, false);
                    }
                } else {
                    ++this.progress;
                }
            }
        } else {
            this.progress = 0;
            this.isWorking = false;
        }
    }

    private void balanceSlots() {
        for (IInvSlot slotA : InventoryIterator.getIterable((IInventory)this.craftMatrix)) {
            ItemStack stackA = slotA.getStackInSlot();
            if (stackA == null) continue;
            for (IInvSlot slotB : InventoryIterator.getIterable((IInventory)this.craftMatrix)) {
                ItemStack stackB;
                if (slotA.getIndex() == slotB.getIndex() || (stackB = slotB.getStackInSlot()) == null || !InvTools.isItemEqual(stackA, stackB) || stackA.stackSize <= stackB.stackSize + 1) continue;
                --stackA.stackSize;
                ++stackB.stackSize;
                return;
            }
        }
    }

    private void findMoreStuff() {
        Collection<IInventory> chests = this.cache.getAdjacentInventories();
        for (IInvSlot slot : InventoryIterator.getIterable((IInventory)this.craftMatrix)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || !stack.isStackable() || stack.stackSize != 1) continue;
            ItemStack request = InvTools.removeOneItem(chests, (IStackFilter)new ArrayStackFilter(stack));
            if (request != null) {
                ++stack.stackSize;
                break;
            }
            if (stack.stackSize <= 1) continue;
            break;
        }
    }

    @Override
    public boolean hasWork() {
        return this.isWorking;
    }

    public void setPaused(boolean p) {
        this.paused = p;
    }

    private void processActions() {
        this.paused = false;
        for (IActionExternal action : this.actions) {
            if (action != Actions.PAUSE) continue;
            this.paused = true;
        }
        this.actions.clear();
    }

    @Override
    public void actionActivated(IActionExternal action) {
        this.actions.add(action);
    }

    public boolean canMakeMore() {
        if (RollingMachineCraftingManager.getInstance().findMatchingRecipe(this.craftMatrix, this.worldObj) == null) {
            return false;
        }
        if (this.useLast) {
            return true;
        }
        for (int i = 0; i < this.craftMatrix.getSizeInventory(); ++i) {
            ItemStack slot = this.craftMatrix.getStackInSlot(i);
            if (slot == null || slot.stackSize > 1) continue;
            return false;
        }
        return true;
    }

    public int[] getAccessibleSlotsFromSide(int var1) {
        return SLOTS;
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        return this.isItemValidForSlot(slot, stack);
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return slot == 0;
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (slot == 0) {
            return false;
        }
        if (stack == null) {
            return false;
        }
        if (!stack.isStackable()) {
            return false;
        }
        if (stack.getItem().hasContainerItem(stack)) {
            return false;
        }
        return this.getStackInSlot(slot) != null;
    }

    public int getSizeInventory() {
        return 10;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inv.getStackInSlot(slot);
    }

    public ItemStack decrStackSize(int slot, int count) {
        return this.inv.decrStackSize(slot, count);
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.inv.setInventorySlotContents(slot, stack);
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return this.inv.getStackInSlotOnClosing(slot);
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return RailcraftTileEntity.isUseableByPlayerHelper(this, player);
    }

    public String getInventoryName() {
        return this.getName();
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public boolean canConnectEnergy(ForgeDirection side) {
        return this.energyStorage != null;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.energyStorage == null) {
            return 0;
        }
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        if (this.energyStorage == null) {
            return 0;
        }
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.energyStorage == null) {
            return 0;
        }
        return this.energyStorage.getMaxEnergyStored();
    }

    private static class RollingContainer
    extends Container {
        private RollingContainer() {
        }

        public boolean canInteractWith(EntityPlayer entityplayer) {
            return true;
        }
    }
}

