/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.api.crafting.IBlastFurnaceRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.TileMultiBlockOven;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.util.inventory.AdjacentInventoryCache;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.InventorySorter;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.ITileFilter;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileBlastFurnace
extends TileMultiBlockOven
implements ISidedInventory {
    public static final IStackFilter INPUT_FILTER = new IStackFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            return RailcraftCraftingManager.blastFurnace.getRecipe(stack) != null;
        }
    };
    public static final IStackFilter FUEL_FILTER = new IStackFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            return stack != null && InvTools.isItemEqual(stack, RailcraftCraftingManager.blastFurnace.getFuels());
        }
    };
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_FUEL = 1;
    public static final int SLOT_OUTPUT = 2;
    private static final int FUEL_PER_TICK = 5;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 3);
    private static final List<MultiBlockPattern> patterns = new ArrayList<MultiBlockPattern>();
    private final IInventory invFuel = new InventoryMapper(this, 1, 1);
    private final IInventory invInput = new InventoryMapper(this, 0, 1);
    private final IInventory invOutput = new InventoryMapper(this, 2, 1);
    private final AdjacentInventoryCache invCache = new AdjacentInventoryCache(this, this.tileCache, new ITileFilter(){

        @Override
        public boolean matches(TileEntity tile) {
            if (tile instanceof TileBlastFurnace) {
                return false;
            }
            if (tile instanceof IInventory) {
                return ((IInventory)tile).getSizeInventory() >= 27;
            }
            return false;
        }
    }, InventorySorter.SIZE_DECENDING);
    public int burnTime = 0;
    public int currentItemBurnTime = 0;
    public boolean clientBurning = false;
    private int finishedAt;

    public TileBlastFurnace() {
        super("railcraft.gui.blast.furnace", 3, patterns);
    }

    public static void placeBlastFurnace(World world, int x, int y, int z, ItemStack input, ItemStack output, ItemStack fuel) {
        Iterator<MultiBlockPattern> iterator = patterns.iterator();
        if (iterator.hasNext()) {
            MultiBlockPattern pattern = iterator.next();
            HashMap<Character, Integer> blockMapping = new HashMap<Character, Integer>();
            blockMapping.put(Character.valueOf('B'), EnumMachineAlpha.BLAST_FURNACE.ordinal());
            blockMapping.put(Character.valueOf('W'), EnumMachineAlpha.BLAST_FURNACE.ordinal());
            TileEntity tile = pattern.placeStructure(world, x, y, z, RailcraftBlocks.getBlockMachineAlpha(), blockMapping);
            if (tile instanceof TileBlastFurnace) {
                TileBlastFurnace master = (TileBlastFurnace)tile;
                master.inv.setInventorySlotContents(0, input);
                master.inv.setInventorySlotContents(2, output);
            }
            return;
        }
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.BLAST_FURNACE;
    }

    @Override
    public IIcon getIcon(int side) {
        if (side > 1 && this.getPatternMarker() == 'W' && this.isStructureValid()) {
            if (this.isBurning()) {
                return this.getMachineType().getTexture(7);
            }
            return this.getMachineType().getTexture(6);
        }
        return this.getMachineType().getTexture(0);
    }

    @Override
    protected boolean isMapPositionValid(int i, int j, int k, char mapPos) {
        Block block = this.worldObj.getBlock(i, j, k);
        switch (mapPos) {
            case 'O': {
                if (block == RailcraftBlocks.getBlockMachineAlpha() && this.worldObj.getBlockMetadata(i, j, k) == this.getBlockMetadata()) break;
                return true;
            }
            case 'B': 
            case 'W': {
                if (block != RailcraftBlocks.getBlockMachineAlpha() || this.worldObj.getBlockMetadata(i, j, k) != this.getBlockMetadata()) break;
                return true;
            }
            case 'A': {
                if (!block.isAir((IBlockAccess)this.worldObj, i, j, k) && block.getMaterial() != Material.lava) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getTotalCookTime() {
        ItemStack input = this.getStackInSlot(0);
        IBlastFurnaceRecipe recipe = RailcraftCraftingManager.blastFurnace.getRecipe(input);
        if (recipe != null) {
            return recipe.getCookTime();
        }
        return 1;
    }

    @Override
    public int getBurnProgressScaled(int i) {
        if (this.burnTime <= 0 || this.currentItemBurnTime <= 0) {
            return 0;
        }
        int scale = this.burnTime * i / this.currentItemBurnTime;
        scale = Math.min(scale, i);
        scale = Math.max(scale, 0);
        return scale;
    }

    private void setLavaIdle() {
        int xLava = this.xCoord + 1;
        int yLava = this.yCoord + 1;
        int zLava = this.zCoord + 1;
        if (this.worldObj.isAirBlock(xLava, yLava, zLava)) {
            this.worldObj.setBlock(xLava, yLava, zLava, Blocks.lava, 7, 3);
        }
    }

    private void setLavaBurn() {
        int xLava = this.xCoord + 1;
        int yLava = this.yCoord + 1;
        int zLava = this.zCoord + 1;
        if (this.worldObj.isAirBlock(xLava, yLava, zLava)) {
            this.worldObj.setBlock(xLava, yLava, zLava, (Block)Blocks.flowing_lava, 1, 3);
        }
        if (this.worldObj.isAirBlock(xLava, ++yLava, zLava)) {
            this.worldObj.setBlock(xLava, yLava, zLava, (Block)Blocks.flowing_lava, 1, 3);
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        TileBlastFurnace mBlock = (TileBlastFurnace)this.getMasterBlock();
        if (mBlock != null) {
            InvTools.moveOneItem(this.invCache.getAdjacentInventories(), mBlock.invFuel, FUEL_FILTER);
        }
        if (this.isMaster()) {
            boolean wasBurning = this.isBurning();
            if (this.clock > this.finishedAt + 10 && this.cookTime <= 0) {
                this.setCooking(false);
            }
            this.burnTime = this.burnTime >= 5 ? (this.burnTime -= 5) : 0;
            if (this.isBurning()) {
                this.setLavaBurn();
            } else {
                this.setLavaIdle();
            }
            ItemStack input = this.getStackInSlot(0);
            if (input != null && input.stackSize > 0) {
                ItemStack output = this.getStackInSlot(2);
                IBlastFurnaceRecipe recipe = RailcraftCraftingManager.blastFurnace.getRecipe(input);
                if (recipe != null && recipe.isRoomForOutput(output)) {
                    int itemBurnTime;
                    ItemStack fuel;
                    if (this.paused) {
                        return;
                    }
                    if (this.burnTime <= 10 && FUEL_FILTER.matches(fuel = this.getStackInSlot(1)) && (itemBurnTime = FuelPlugin.getBurnTime(fuel)) > 0) {
                        this.burnTime = this.currentItemBurnTime = itemBurnTime + this.burnTime;
                        this.setInventorySlotContents(1, InvTools.depleteItem(fuel));
                    }
                    if (this.isBurning()) {
                        ++this.cookTime;
                        this.setCooking(true);
                        if (this.cookTime >= recipe.getCookTime()) {
                            this.cookTime = 0;
                            this.finishedAt = this.clock;
                            if (output == null) {
                                this.setInventorySlotContents(2, recipe.getOutput());
                            } else {
                                output.stackSize += recipe.getOutputStackSize();
                            }
                            this.decrStackSize(0, 1);
                        }
                    }
                } else {
                    this.cookTime = 0;
                    this.setCooking(false);
                }
            } else {
                this.cookTime = 0;
                this.setCooking(false);
            }
            if (wasBurning != this.isBurning()) {
                this.sendUpdateToClient();
            }
        }
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        TileMultiBlock masterBlock = this.getMasterBlock();
        if (masterBlock != null) {
            GuiHandler.openGui(EnumGui.BLAST_FURNACE, player, this.worldObj, masterBlock.xCoord, masterBlock.yCoord, masterBlock.zCoord);
            return true;
        }
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setInteger("burnTime", this.burnTime);
        data.setInteger("currentItemBurnTime", this.currentItemBurnTime);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.burnTime = data.getInteger("burnTime");
        this.currentItemBurnTime = data.getInteger("currentItemBurnTime");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.burnTime > 0);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.clientBurning = data.readBoolean();
    }

    @Override
    public boolean needsFuel() {
        ItemStack fuel = this.getStackInSlot(1);
        return fuel == null || fuel.stackSize < 8;
    }

    @Override
    public boolean isBurning() {
        TileBlastFurnace mBlock = (TileBlastFurnace)this.getMasterBlock();
        if (mBlock != null) {
            if (this.worldObj.isRemote) {
                return mBlock.clientBurning;
            }
            return mBlock.burnTime > 0;
        }
        return false;
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (!super.isItemValidForSlot(slot, stack)) {
            return false;
        }
        switch (slot) {
            case 2: {
                return false;
            }
            case 1: {
                return FUEL_FILTER.matches(stack);
            }
            case 0: {
                return INPUT_FILTER.matches(stack);
            }
        }
        return false;
    }

    public int[] getAccessibleSlotsFromSide(int var1) {
        return SLOTS;
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        return this.isItemValidForSlot(slot, stack);
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return slot == 2;
    }

    static {
        char[][][] map = new char[][][]{new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'W', 'B', 'W', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'A', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'A', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map, 2, 1, 2));
    }
}

