/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine;

import java.util.List;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileMultiBlockInventory
extends TileMultiBlock
implements IInventory {
    protected final StandaloneInventory inv;
    private final String guiTag;

    public TileMultiBlockInventory(String guiTag, int invSize, List<? extends MultiBlockPattern> patterns) {
        super(patterns);
        this.inv = new StandaloneInventory(invSize, this);
        this.guiTag = guiTag;
    }

    protected void dropItem(ItemStack stack) {
        InvTools.dropItem(stack, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    public ItemStack decrStackSize(int i, int j) {
        TileMultiBlockInventory mBlock = (TileMultiBlockInventory)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.inv.decrStackSize(i, j);
        }
        return null;
    }

    public ItemStack getStackInSlot(int i) {
        TileMultiBlockInventory mBlock = (TileMultiBlockInventory)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.inv.getStackInSlot(i);
        }
        return null;
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
        TileMultiBlockInventory mBlock = (TileMultiBlockInventory)this.getMasterBlock();
        if (mBlock != null) {
            mBlock.inv.setInventorySlotContents(i, itemstack);
        }
    }

    public boolean isItemValidForSlot(int p_94041_1_, ItemStack p_94041_2_) {
        return this.isStructureValid();
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.inv.writeToNBT("invStructure", data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.inv.readFromNBT("invStructure", data);
    }

    public String getInventoryName() {
        return this.getName();
    }

    public int getSizeInventory() {
        return this.inv.getSizeInventory();
    }

    public ItemStack getStackInSlotOnClosing(int var1) {
        return null;
    }

    @Override
    public String getName() {
        return LocalizationPlugin.translate(this.guiTag);
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return RailcraftTileEntity.isUseableByPlayerHelper(this, player);
    }
}

