/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import mods.railcraft.api.core.IPostConnection;
import mods.railcraft.api.core.items.ITrackItem;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.machine.BlockMachine;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.items.IActivationBlockingItem;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;

public abstract class TileMachineBase
extends RailcraftTileEntity {
    private boolean checkedBlock = false;

    public abstract IEnumMachine getMachineType();

    @Override
    public String getLocalizationTag() {
        return this.getMachineType().getTag() + ".name";
    }

    @Override
    public final short getId() {
        if (this.getMachineType() == null) {
            return 0;
        }
        return (short)this.getMachineType().ordinal();
    }

    public boolean canCreatureSpawn(EnumCreatureType type) {
        return true;
    }

    public ArrayList<ItemStack> getDrops(int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getMachineType().getItem());
        return items;
    }

    public ArrayList<ItemStack> getBlockDroppedSilkTouch(int fortune) {
        return this.getDrops(fortune);
    }

    public boolean canSilkHarvest(EntityPlayer player) {
        return false;
    }

    public void initFromItem(ItemStack stack) {
    }

    public void onBlockAdded() {
    }

    public void onBlockRemoval() {
        if (this instanceof IInventory) {
            InvTools.dropInventory(new InventoryMapper((IInventory)this), this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public boolean blockActivated(EntityPlayer player, int side) {
        if (player.isSneaking()) {
            return false;
        }
        ItemStack stack = player.getCurrentEquippedItem();
        if (stack != null) {
            if (stack.getItem() instanceof IActivationBlockingItem) {
                return false;
            }
            if (stack.getItem() instanceof ITrackItem) {
                return false;
            }
            if (TrackTools.isRailItem(stack.getItem())) {
                return false;
            }
        }
        return this.openGui(player);
    }

    public boolean rotateBlock(ForgeDirection axis) {
        return false;
    }

    public ForgeDirection[] getValidRotations() {
        return ForgeDirection.VALID_DIRECTIONS;
    }

    public boolean isSideSolid(ForgeDirection side) {
        return true;
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isNotHost(this.worldObj)) {
            return;
        }
        if (!this.checkedBlock) {
            this.checkedBlock = true;
            if (this.getBlockType() != null && this.getMachineType() != null) {
                if (!this.getMachineType().isAvaliable()) {
                    this.worldObj.setBlockToAir(this.xCoord, this.yCoord, this.zCoord);
                    return;
                }
                if (this.getBlockType() != this.getMachineType().getBlock()) {
                    Game.log(Level.INFO, "Updating Machine Tile Block: {0} {1}->{2}, [{3}, {4}, {5}]", this.getClass().getSimpleName(), this.getBlockType(), this.getMachineType().getBlock(), this.xCoord, this.yCoord, this.zCoord);
                    this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord, this.getMachineType().getBlock(), (int)this.getId(), 3);
                    this.validate();
                    this.worldObj.setTileEntity(this.xCoord, this.yCoord, this.zCoord, (TileEntity)this);
                    this.updateContainingBlockInfo();
                }
                int meta = this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord);
                if (this.getBlockType() != null && this.getClass() != ((BlockMachine)this.getBlockType()).getMachineProxy().getMachine(meta).getTileClass()) {
                    this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, (int)this.getId(), 3);
                    this.validate();
                    this.worldObj.setTileEntity(this.xCoord, this.yCoord, this.zCoord, (TileEntity)this);
                    Game.log(Level.INFO, "Updating Machine Tile Metadata: {0} {1}->{2}, [{3}, {4}, {5}]", this.getClass().getSimpleName(), meta, this.getId(), this.xCoord, this.yCoord, this.zCoord);
                    this.updateContainingBlockInfo();
                }
            }
        }
    }

    public boolean openGui(EntityPlayer player) {
        return false;
    }

    public IIcon getIcon(int side) {
        return this.getMachineType().getTexture(side);
    }

    public int getLightValue() {
        return 0;
    }

    public float getResistance(Entity exploder) {
        return 4.5f;
    }

    public float getHardness() {
        return 2.0f;
    }

    public boolean isPoweringTo(int side) {
        return false;
    }

    public boolean canConnectRedstone(int dir) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(Random rand) {
    }

    public int colorMultiplier() {
        return 0xFFFFFF;
    }

    public boolean recolourBlock(int color) {
        return false;
    }

    public IPostConnection.ConnectStyle connectsToPost(ForgeDirection side) {
        if (this.isSideSolid(side.getOpposite())) {
            return IPostConnection.ConnectStyle.TWO_THIN;
        }
        return IPostConnection.ConnectStyle.NONE;
    }
}

