/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.hidden;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.hidden.BlockHidden;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.ItemGoggles;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;

public class TileHidden
extends RailcraftTileEntity {
    private static final int DURATION_MIINUTES = 15;
    private static final long DURATION_MILLISECONDS = TimeUnit.MILLISECONDS.convert(15L, TimeUnit.MINUTES);
    public WorldCoordinate lastMarker;
    public long colorSeed;
    public long timestamp = -1L;

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isNotHost(this.worldObj)) {
            if (this.lastMarker != null && EffectManager.instance.isGoggleAuraActive(ItemGoggles.GoggleAura.TRACKING)) {
                EffectManager.instance.trailEffect(this.lastMarker.x, this.lastMarker.y, this.lastMarker.z, this, this.colorSeed);
            }
            return;
        }
        if (this.timestamp == -1L) {
            return;
        }
        if (this.clock % 64 == 0) {
            boolean timeElapsed;
            if (BlockHidden.getBlock() == null || !RailcraftConfig.isTrackingAuraEnabled()) {
                this.worldObj.setBlockToAir(this.xCoord, this.yCoord, this.zCoord);
                return;
            }
            Block block = WorldPlugin.getBlock((IBlockAccess)this.worldObj, this.xCoord, this.yCoord, this.zCoord);
            if (block != BlockHidden.getBlock()) {
                this.worldObj.removeTileEntity(this.xCoord, this.yCoord, this.zCoord);
                return;
            }
            boolean bl = timeElapsed = System.currentTimeMillis() - this.timestamp >= DURATION_MILLISECONDS;
            if (timeElapsed) {
                this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord, Blocks.air, 0, 6);
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        if (this.lastMarker != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.setInteger("dim", this.lastMarker.dimension);
            nbt.setInteger("x", this.lastMarker.x);
            nbt.setInteger("y", this.lastMarker.y);
            nbt.setInteger("z", this.lastMarker.z);
            data.setTag("last", (NBTBase)nbt);
        }
        data.setLong("seed", this.colorSeed);
        data.setLong("time", this.timestamp);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.hasKey("last")) {
            NBTTagCompound nbt = data.getCompoundTag("last");
            int dim = nbt.getInteger("dim");
            int x = nbt.getInteger("x");
            int y = nbt.getInteger("y");
            int z = nbt.getInteger("z");
            this.lastMarker = new WorldCoordinate(dim, x, y, z);
        }
        this.colorSeed = data.getLong("seed");
        this.timestamp = data.getLong("time");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeLong(this.colorSeed);
        data.writeBoolean(this.lastMarker != null);
        if (this.lastMarker != null) {
            data.writeInt(this.lastMarker.dimension);
            data.writeInt(this.lastMarker.x);
            data.writeInt(this.lastMarker.y);
            data.writeInt(this.lastMarker.z);
        }
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.colorSeed = data.readLong();
        if (data.readBoolean()) {
            int dim = data.readInt();
            int x = data.readInt();
            int y = data.readInt();
            int z = data.readInt();
            this.lastMarker = new WorldCoordinate(dim, x, y, z);
        }
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public String getLocalizationTag() {
        return "";
    }

    @Override
    public short getId() {
        return 111;
    }
}

