/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.detector.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import mods.railcraft.common.blocks.detector.Detector;
import mods.railcraft.common.blocks.detector.EnumDetector;
import mods.railcraft.common.carts.Train;
import mods.railcraft.common.gui.EnumGui;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class DetectorTrain
extends Detector {
    private short trainSize = (short)5;

    @Override
    public EnumDetector getType() {
        return EnumDetector.TRAIN;
    }

    @Override
    public int testCarts(List<EntityMinecart> carts) {
        for (EntityMinecart cart : carts) {
            int count = Train.getTrain(cart).size();
            if (count < this.getTrainSize()) continue;
            return 15;
        }
        return 0;
    }

    @Override
    protected short updateInterval() {
        return 4;
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        this.openGui(EnumGui.DETECTOR_TRAIN, player);
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setShort("size", this.getTrainSize());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.setTrainSize(data.getShort("size"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeShort(this.getTrainSize());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.setTrainSize(data.readShort());
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeShort(this.getTrainSize());
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.setTrainSize(data.readShort());
    }

    public short getTrainSize() {
        return this.trainSize;
    }

    public void setTrainSize(short trainSize) {
        this.trainSize = trainSize;
    }
}

