/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.detector.types;

import java.util.List;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.detector.DetectorSecured;
import mods.railcraft.common.blocks.detector.EnumDetector;
import mods.railcraft.common.blocks.signals.IRouter;
import mods.railcraft.common.blocks.signals.IRoutingTile;
import mods.railcraft.common.blocks.signals.RoutingLogic;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.buttons.IMultiButtonState;
import mods.railcraft.common.gui.buttons.MultiButtonController;
import mods.railcraft.common.items.ItemRoutingTable;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class DetectorRouting
extends DetectorSecured
implements IRouter,
IRoutingTile {
    private RoutingLogic logic;
    private final StandaloneInventory inv = new StandaloneInventory(1, null, new StandaloneInventory.Callback(){

        @Override
        public void markDirty() {
            DetectorRouting.this.logic = null;
            DetectorRouting.this.tile.markDirty();
        }

        @Override
        public String getInventoryName() {
            return DetectorRouting.this.tile.getName();
        }
    });
    private final MultiButtonController<IRouter.RoutingButtonState> routingController = new MultiButtonController(0, (IMultiButtonState[])IRouter.RoutingButtonState.values());
    private boolean powered;

    @Override
    public MultiButtonController<IRouter.RoutingButtonState> getRoutingController() {
        return this.routingController;
    }

    @Override
    public EnumDetector getType() {
        return EnumDetector.ROUTING;
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        ItemStack current = player.inventory.getCurrentItem();
        if (current != null && current.getItem() instanceof ItemRoutingTable && this.inv.getStackInSlot(0) == null) {
            ItemStack copy = current.copy();
            copy.stackSize = 1;
            this.inv.setInventorySlotContents(0, copy);
            if (!player.capabilities.isCreativeMode) {
                player.inventory.setInventorySlotContents(player.inventory.currentItem, InvTools.depleteItem(current));
                player.inventory.markDirty();
            }
            return true;
        }
        this.openGui(EnumGui.DETECTOR_ROUTING, player);
        return true;
    }

    @Override
    public void onBlockRemoved() {
        super.onBlockRemoved();
        InvTools.dropInventory(this.inv, this.tile.getWorldObj(), this.tile.xCoord, this.tile.yCoord, this.tile.zCoord);
    }

    @Override
    protected boolean shouldTest() {
        this.refreshLogic();
        return this.logic != null && this.logic.isValid();
    }

    @Override
    public int testCarts(List<EntityMinecart> carts) {
        if (this.logic == null || !this.logic.isValid()) {
            return 0;
        }
        for (EntityMinecart cart : carts) {
            if (this.routingController.getButtonState() == IRouter.RoutingButtonState.PRIVATE && !this.getOwner().equals((Object)CartTools.getCartOwner(cart)) || !this.logic.matches(this, cart)) continue;
            return 15;
        }
        return 0;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        this.checkPower();
    }

    private void checkPower() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (side == this.tile.direction || !PowerPlugin.isBlockBeingPowered(this.getWorld(), this.tile.xCoord, this.tile.yCoord, this.tile.zCoord, side)) continue;
            this.powered = true;
            return;
        }
        this.powered = false;
    }

    @Override
    public RoutingLogic getLogic() {
        this.refreshLogic();
        return this.logic;
    }

    @Override
    public void resetLogic() {
        this.logic = null;
    }

    private void refreshLogic() {
        if (this.logic == null && this.inv.getStackInSlot(0) != null) {
            this.logic = ItemRoutingTable.getLogic(this.inv.getStackInSlot(0));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.inv.writeToNBT("inv", data);
        this.routingController.writeToNBT(data, "railwayType");
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.inv.readFromNBT("inv", data);
        this.routingController.readFromNBT(data, "railwayType");
    }

    @Override
    public IInventory getInventory() {
        return this.inv;
    }
}

