/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.detector;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.detector.EnumDetector;
import mods.railcraft.common.blocks.detector.ItemDetector;
import mods.railcraft.common.blocks.detector.TileDetector;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.IActivationBlockingItem;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.HarvestPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockDetector
extends BlockContainer {
    private static BlockDetector block;

    public static void registerBlock() {
        if (block == null && RailcraftConfig.isBlockEnabled("detector")) {
            block = new BlockDetector();
            RailcraftRegistry.register((Block)block, ItemDetector.class);
            HarvestPlugin.setHarvestLevel((Block)block, "crowbar", 0);
            for (EnumDetector d : EnumDetector.VALUES) {
                ItemStack stack = new ItemStack((Block)block, 1, d.ordinal());
                RailcraftRegistry.register(stack);
            }
        }
    }

    public static BlockDetector getBlock() {
        return block;
    }

    public BlockDetector() {
        super(Material.rock);
        this.setBlockName("railcraft.detector");
        this.setResistance(4.5f);
        this.setHardness(2.0f);
        this.setStepSound(soundTypeStone);
        this.setCreativeTab(CreativePlugin.RAILCRAFT_TAB);
        GameRegistry.registerTileEntity(TileDetector.class, (String)"RCDetectorTile");
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileDetector) {
            TileDetector detector = (TileDetector)tile;
            return detector.getDetector().getType().getItem();
        }
        return super.getPickBlock(target, world, x, y, z, player);
    }

    public boolean isBlockNormalCube() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int i, int j, int k, ForgeDirection side) {
        return true;
    }

    public int damageDropped(int meta) {
        return meta;
    }

    public ArrayList<ItemStack> getDrops(World world, int i, int j, int k, int md, int fortune) {
        TileEntity tile = world.getTileEntity(i, j, k);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (tile instanceof TileDetector) {
            items.add(((TileDetector)tile).getDetector().getType().getItem());
        }
        return items;
    }

    public void harvestBlock(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        player.addStat(StatList.mineBlockStatArray[BlockDetector.getIdFromBlock((Block)this)], 1);
        player.addExhaustion(0.025f);
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileDetector) {
            ((TileDetector)tile).getDetector().onBlockRemoved();
        }
        if (Game.isHost(world) && !player.capabilities.isCreativeMode) {
            this.dropBlockAsItem(world, x, y, z, 0, 0);
        }
        return world.setBlockToAir(x, y, z);
    }

    public TileEntity createNewTileEntity(World var1, int meta) {
        return null;
    }

    public TileEntity createTileEntity(World var1, int meta) {
        return new TileDetector();
    }

    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        TileEntity tile = world.getTileEntity(i, j, k);
        if (tile instanceof TileDetector) {
            ((TileDetector)tile).direction = MiscTools.getSideClosestToPlayer(world, i, j, k, entityliving);
            ((TileDetector)tile).onBlockPlacedBy(entityliving, stack);
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float u1, float u2, float u3) {
        TileEntity tile;
        if (player.isSneaking()) {
            return false;
        }
        ItemStack current = player.getCurrentEquippedItem();
        if (current != null) {
            Item item = current.getItem();
            if (item instanceof IActivationBlockingItem) {
                return false;
            }
            if (TrackTools.isRailItem(item)) {
                return false;
            }
        }
        if ((tile = world.getTileEntity(x, y, z)) instanceof TileDetector) {
            return ((TileDetector)tile).blockActivated(player);
        }
        return false;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        super.onNeighborBlockChange(world, x, y, z, block);
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileDetector) {
            TileDetector detector = (TileDetector)tile;
            detector.onNeighborBlockChange(block);
        }
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileDetector) {
            TileDetector detector = (TileDetector)tile;
            detector.direction = detector.direction == axis ? axis.getOpposite() : axis;
            world.markBlockForUpdate(x, y, z);
            return true;
        }
        return false;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        return ForgeDirection.VALID_DIRECTIONS;
    }

    public void registerBlockIcons(IIconRegister iconRegister) {
        for (EnumDetector det : EnumDetector.VALUES) {
            String name = "railcraft:" + MiscTools.cleanTag(det.getTag());
            det.textures = TextureAtlasSheet.unstitchIcons(iconRegister, name, 3);
        }
    }

    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileDetector) {
            TileDetector detectorTile = (TileDetector)tile;
            EnumDetector det = detectorTile.getDetector().getType();
            if (detectorTile.direction.ordinal() == side) {
                if (detectorTile.powerState != 0) {
                    return det.textures[2];
                }
                return det.textures[1];
            }
            return det.textures[0];
        }
        return null;
    }

    public IIcon getIcon(int side, int meta) {
        EnumDetector det = EnumDetector.fromOrdinal(meta);
        if (side == 3) {
            return det.textures[2];
        }
        return det.textures[0];
    }

    public float getBlockHardness(World world, int x, int y, int z) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileDetector) {
            return ((TileDetector)tile).getDetector().getHardness();
        }
        return super.getBlockHardness(world, x, y, z);
    }

    public boolean canProvidePower() {
        return true;
    }

    public int isProvidingWeakPower(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity t = world.getTileEntity(x, y, z);
        if (t instanceof TileDetector) {
            TileDetector tile = (TileDetector)t;
            if (tile.direction == MiscTools.getOppositeSide(side)) {
                return tile.powerState;
            }
        }
        return 0;
    }

    public int isProvidingStrongPower(IBlockAccess world, int x, int y, int z, int side) {
        return this.isProvidingWeakPower(world, x, y, z, side);
    }

    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
        world.markBlockForUpdate(i, j, k);
        if (Game.isNotHost(world)) {
            return;
        }
        world.notifyBlocksOfNeighborChange(i + 1, j, k, (Block)this);
        world.notifyBlocksOfNeighborChange(i - 1, j, k, (Block)this);
        world.notifyBlocksOfNeighborChange(i, j, k + 1, (Block)this);
        world.notifyBlocksOfNeighborChange(i, j, k - 1, (Block)this);
        world.notifyBlocksOfNeighborChange(i, j - 1, k, (Block)this);
        world.notifyBlocksOfNeighborChange(i, j + 1, k, (Block)this);
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int metadata) {
        super.breakBlock(world, x, y, z, (Block)this, metadata);
        if (Game.isNotHost(world)) {
            return;
        }
        world.notifyBlocksOfNeighborChange(x + 1, y, z, (Block)this);
        world.notifyBlocksOfNeighborChange(x - 1, y, z, (Block)this);
        world.notifyBlocksOfNeighborChange(x, y, z + 1, (Block)this);
        world.notifyBlocksOfNeighborChange(x, y, z - 1, (Block)this);
        world.notifyBlocksOfNeighborChange(x, y - 1, z, (Block)this);
        world.notifyBlocksOfNeighborChange(x, y + 1, z, (Block)this);
    }

    public boolean canConnectRedstone(IBlockAccess world, int i, int j, int k, int dir) {
        TileEntity t = world.getTileEntity(i, j, k);
        if (t instanceof TileDetector) {
            TileDetector tile = (TileDetector)t;
            if (dir == 1 && tile.direction.ordinal() == 5) {
                return true;
            }
            if (dir == 3 && tile.direction.ordinal() == 4) {
                return true;
            }
            if (dir == 2 && tile.direction.ordinal() == 3) {
                return true;
            }
            if (dir == 0 && tile.direction.ordinal() == 2) {
                return true;
            }
        }
        return false;
    }

    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        for (EnumDetector detector : EnumDetector.VALUES) {
            if (!detector.isEnabled()) continue;
            list.add(detector.getItem());
        }
    }
}

