/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.wall;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import mods.railcraft.common.blocks.aesthetics.brick.EnumBrick;
import mods.railcraft.common.blocks.aesthetics.wall.BlockRailcraftWall;
import mods.railcraft.common.blocks.aesthetics.wall.WallInfo;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public enum EnumWallBeta implements WallInfo
{
    QUARTZ,
    QUARTZ_CHISELED,
    IRON,
    GOLD,
    DIAMOND,
    ABYSSAL_BRICK,
    QUARRIED_BRICK,
    BLOODSTAINED_BRICK,
    BLEACHEDBONE_BRICK;

    public static final EnumWallBeta[] VALUES;
    private static final List<EnumWallBeta> creativeList;
    private Block source;
    private int sourceMeta = 0;

    public static void initialize() {
        EnumWallBeta.QUARTZ.sourceMeta = 0;
        EnumWallBeta.QUARTZ.source = Blocks.quartz_block;
        EnumWallBeta.QUARTZ_CHISELED.sourceMeta = 1;
        EnumWallBeta.QUARTZ_CHISELED.source = Blocks.quartz_block;
        EnumWallBeta.IRON.source = Blocks.iron_block;
        EnumWallBeta.GOLD.source = Blocks.gold_block;
        EnumWallBeta.DIAMOND.source = Blocks.diamond_block;
        EnumWallBeta.ABYSSAL_BRICK.source = EnumBrick.ABYSSAL.getBlock();
        EnumWallBeta.QUARRIED_BRICK.source = EnumBrick.QUARRIED.getBlock();
        EnumWallBeta.BLOODSTAINED_BRICK.source = EnumBrick.BLOODSTAINED.getBlock();
        EnumWallBeta.BLEACHEDBONE_BRICK.source = EnumBrick.BLEACHEDBONE.getBlock();
        for (EnumWallBeta wall : VALUES) {
            if (!wall.isEnabled() || wall.source == null) continue;
            CraftingPlugin.addShapedRecipe(wall.getItem(6), "SSS", "SSS", Character.valueOf('S'), wall.getSourceItem());
        }
        creativeList.addAll(Arrays.asList(VALUES));
    }

    public static WallInfo fromMeta(int id) {
        if (id < 0 || id >= VALUES.length) {
            return VALUES[0];
        }
        return VALUES[id];
    }

    public static List<EnumWallBeta> getCreativeList() {
        return creativeList;
    }

    @Override
    public Block getSource() {
        return this.source;
    }

    @Override
    public int getSourceMeta() {
        return this.sourceMeta;
    }

    @Override
    public ItemStack getSourceItem() {
        if (this.source == null) {
            return null;
        }
        return new ItemStack(this.source, 1, this.sourceMeta);
    }

    @Override
    public Block getBlock() {
        return BlockRailcraftWall.getBlockBeta();
    }

    @Override
    public ItemStack getItem() {
        return this.getItem(1);
    }

    @Override
    public ItemStack getItem(int qty) {
        Block block = this.getBlock();
        if (block == null) {
            return null;
        }
        return new ItemStack(block, qty, this.ordinal());
    }

    @Override
    public String getTag() {
        return "tile.railcraft.wall." + this.name().replace("_", ".").toLowerCase(Locale.ENGLISH);
    }

    @Override
    public boolean isEnabled() {
        return ModuleManager.isModuleLoaded(ModuleManager.Module.STRUCTURES) && RailcraftConfig.isSubBlockEnabled(this.getTag()) && this.getBlock() != null;
    }

    @Override
    public float getBlockHardness(World world, int x, int y, int z) {
        Block block = this.getSource();
        if (block == null) {
            return Blocks.brick_block.getBlockHardness(world, x, y, z);
        }
        return block.getBlockHardness(world, x, y, z);
    }

    @Override
    public float getExplosionResistance(Entity entity) {
        Block block = this.getSource();
        if (block == null) {
            return Blocks.brick_block.getExplosionResistance(entity);
        }
        return block.getExplosionResistance(entity);
    }

    static {
        VALUES = EnumWallBeta.values();
        creativeList = new ArrayList<EnumWallBeta>();
    }
}

