/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.slab;

import mods.railcraft.common.blocks.aesthetics.EnumBlockMaterial;
import mods.railcraft.common.blocks.aesthetics.slab.BlockRailcraftSlab;
import mods.railcraft.common.blocks.aesthetics.slab.TileSlab;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemSlab
extends ItemBlock {
    public ItemSlab(Block block) {
        super(block);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
        this.setUnlocalizedName("railcraft.slab");
    }

    public String getUnlocalizedName(ItemStack stack) {
        return BlockRailcraftSlab.getTag(EnumBlockMaterial.fromOrdinal(stack.getItemDamage()));
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (stack.stackSize == 0) {
            return false;
        }
        if (!player.canPlayerEdit(x, y, z, side, stack)) {
            return false;
        }
        if (this.isSingleSlab(world, x, y, z, side)) {
            this.tryAddSlab(world, x, y, z, stack);
            return true;
        }
        if (this.isSingleSlabShifted(world, x, y, z, side)) {
            ForgeDirection s = ForgeDirection.getOrientation((int)side);
            x = MiscTools.getXOnSide(x, s);
            y = MiscTools.getYOnSide(y, s);
            z = MiscTools.getZOnSide(z, s);
            this.tryAddSlab(world, x, y, z, stack);
            return true;
        }
        return super.onItemUse(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    private boolean isSingleSlab(World world, int x, int y, int z, int side) {
        TileSlab slab;
        if (world.getBlock(x, y, z) == this.field_150939_a && (slab = BlockRailcraftSlab.getSlabTile((IBlockAccess)world, x, y, z)) != null) {
            boolean up = slab.isTopSlab();
            if ((side == 1 && !up || side == 0 && up) && !slab.isDoubleSlab()) {
                return true;
            }
        }
        return false;
    }

    private boolean isSingleSlabShifted(World world, int x, int y, int z, int side) {
        TileSlab slab;
        ForgeDirection s = ForgeDirection.getOrientation((int)side);
        return world.getBlock(x = MiscTools.getXOnSide(x, s), y = MiscTools.getYOnSide(y, s), z = MiscTools.getZOnSide(z, s)) == this.field_150939_a && (slab = BlockRailcraftSlab.getSlabTile((IBlockAccess)world, x, y, z)) != null && !slab.isDoubleSlab();
    }

    private void tryAddSlab(World world, int x, int y, int z, ItemStack stack) {
        BlockRailcraftSlab block;
        TileSlab slab = BlockRailcraftSlab.getSlabTile((IBlockAccess)world, x, y, z);
        if (slab != null && world.checkNoEntityCollision((block = BlockRailcraftSlab.getBlock()).getCollisionBoundingBoxFromPool(world, x, y, z)) && slab.addSlab(EnumBlockMaterial.fromOrdinal(stack.getItemDamage()))) {
            world.playSoundEffect((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), ((Block)block).stepSound.func_150496_b(), (((Block)block).stepSound.getVolume() + 1.0f) / 2.0f, ((Block)block).stepSound.getPitch() * 0.8f);
            --stack.stackSize;
        }
    }

    public boolean func_150936_a(World world, int x, int y, int z, int side, EntityPlayer par6EntityPlayer, ItemStack stack) {
        if (this.isSingleSlab(world, x, y, z, side)) {
            return true;
        }
        if (this.isSingleSlabShifted(world, x, y, z, side)) {
            return true;
        }
        return super.func_150936_a(world, x, y, z, side, par6EntityPlayer, stack);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        Block block = this.field_150939_a;
        if (!world.checkNoEntityCollision(block.getCollisionBoundingBoxFromPool(world, x, y, z))) {
            return false;
        }
        if (!world.setBlock(x, y, z, this.field_150939_a)) {
            return false;
        }
        if (world.getBlock(x, y, z) == this.field_150939_a) {
            TileSlab slab = BlockRailcraftSlab.getSlabTile((IBlockAccess)world, x, y, z);
            if (slab != null) {
                if (side != 0 && (side == 1 || (double)hitY <= 0.5)) {
                    slab.setBottomSlab(EnumBlockMaterial.fromOrdinal(stack.getItemDamage()));
                } else {
                    slab.setTopSlab(EnumBlockMaterial.fromOrdinal(stack.getItemDamage()));
                }
            }
            this.field_150939_a.onBlockPlacedBy(world, x, y, z, (EntityLivingBase)player, stack);
            this.field_150939_a.onPostBlockPlaced(world, x, y, z, metadata);
        }
        return true;
    }
}

