/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.post;

import mods.railcraft.client.sounds.RailcraftSound;
import mods.railcraft.common.blocks.signals.MaterialStructure;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockPostBase
extends Block {
    private static final float SIZE = 0.15f;
    private static final float SELECT = 0.25f;
    private final int renderType;

    public BlockPostBase(int renderType) {
        super((Material)new MaterialStructure());
        this.renderType = renderType;
        this.setStepSound(RailcraftSound.getInstance());
        this.setResistance(15.0f);
        this.setHardness(3.0f);
        this.setCreativeTab(CreativePlugin.RAILCRAFT_TAB);
    }

    public boolean isPlatform(int meta) {
        return false;
    }

    public int damageDropped(int meta) {
        return meta;
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        if (this.isPlatform(world.getBlockMetadata(x, y, z))) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            this.setBlockBounds(0.2f, 0.0f, 0.2f, 0.8f, 1.0f, 0.8f);
        }
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        if (this.isPlatform(world.getBlockMetadata(x, y, z))) {
            return AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        }
        if (!(world.isAirBlock(x, y - 1, z) || world.getBlock(x, y - 1, z) instanceof BlockPostBase || TrackTools.isRailBlockAt((IBlockAccess)world, x, y + 1, z))) {
            return AxisAlignedBB.getBoundingBox((double)((float)x + 0.15f), (double)y, (double)((float)z + 0.15f), (double)((float)(x + 1) - 0.15f), (double)((double)y + 1.5), (double)((float)(z + 1) - 0.15f));
        }
        return AxisAlignedBB.getBoundingBox((double)((float)x + 0.15f), (double)y, (double)((float)z + 0.15f), (double)((float)(x + 1) - 0.15f), (double)(y + 1), (double)((float)(z + 1) - 0.15f));
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        if (this.isPlatform(world.getBlockMetadata(x, y, z))) {
            return AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        }
        return AxisAlignedBB.getBoundingBox((double)((float)x + 0.25f), (double)y, (double)((float)z + 0.25f), (double)((float)(x + 1) - 0.25f), (double)((float)y + 1.0f), (double)((float)(z + 1) - 0.25f));
    }

    public boolean getBlocksMovement(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.DOWN || side == ForgeDirection.UP;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return this.renderType;
    }

    public boolean isBlockNormalCube() {
        return false;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }
}

