/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.lantern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mods.railcraft.common.blocks.aesthetics.EnumBlockMaterial;
import mods.railcraft.common.blocks.aesthetics.lantern.BlockLantern;
import mods.railcraft.common.blocks.aesthetics.lantern.LanternInfo;
import mods.railcraft.common.blocks.aesthetics.slab.BlockRailcraftSlab;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public enum EnumLanternMetal implements LanternInfo
{
    IRON,
    GOLD,
    COPPER,
    TIN,
    LEAD,
    STEEL;

    public static final EnumLanternMetal[] VALUES;
    public static final Map<String, EnumLanternMetal> NAMES;
    public static final List<EnumLanternMetal> creativeList;
    private ItemStack source;

    public static void initialize() {
        EnumLanternMetal.IRON.source = BlockRailcraftSlab.getItem(EnumBlockMaterial.IRON);
        EnumLanternMetal.GOLD.source = BlockRailcraftSlab.getItem(EnumBlockMaterial.GOLD);
        EnumLanternMetal.COPPER.source = BlockRailcraftSlab.getItem(EnumBlockMaterial.COPPER);
        EnumLanternMetal.TIN.source = BlockRailcraftSlab.getItem(EnumBlockMaterial.TIN);
        EnumLanternMetal.LEAD.source = BlockRailcraftSlab.getItem(EnumBlockMaterial.LEAD);
        EnumLanternMetal.STEEL.source = BlockRailcraftSlab.getItem(EnumBlockMaterial.STEEL);
        for (EnumLanternMetal lamp : VALUES) {
            NAMES.put(lamp.name(), lamp);
            if (lamp.isEnabled() && lamp.source != null) {
                CraftingPlugin.addShapedRecipe(lamp.getItem(1), " S ", " T ", " S ", Character.valueOf('S'), lamp.getSource(), Character.valueOf('T'), new ItemStack(Blocks.torch));
            }
            creativeList.add(lamp);
        }
    }

    public static LanternInfo fromOrdinal(int id) {
        if (id < 0 || id >= VALUES.length) {
            return VALUES[0];
        }
        return VALUES[id];
    }

    public static EnumLanternMetal fromName(String name) {
        EnumLanternMetal lamp = NAMES.get(name);
        if (lamp != null) {
            return lamp;
        }
        return IRON;
    }

    @Override
    public IIcon getTexture(int side) {
        return InvTools.getBlockFromStack(this.source).getIcon(ForgeDirection.UP.ordinal(), this.source.getItemDamage());
    }

    @Override
    public Block getBlock() {
        return BlockLantern.getBlockMetal();
    }

    @Override
    public ItemStack getSource() {
        if (this.source == null) {
            return null;
        }
        return this.source.copy();
    }

    @Override
    public ItemStack getItem() {
        return this.getItem(1);
    }

    @Override
    public ItemStack getItem(int qty) {
        Block block = this.getBlock();
        if (block == null) {
            return null;
        }
        return new ItemStack(block, qty, this.ordinal());
    }

    @Override
    public String getTag() {
        return "railcraft.lantern.metal." + this.name().replace("_", ".").toLowerCase(Locale.ENGLISH);
    }

    @Override
    public boolean isEnabled() {
        return ModuleManager.isModuleLoaded(ModuleManager.Module.STRUCTURES) && RailcraftConfig.isSubBlockEnabled(this.getTag()) && this.getBlock() != null;
    }

    static {
        VALUES = EnumLanternMetal.values();
        NAMES = new HashMap<String, EnumLanternMetal>();
        creativeList = new ArrayList<EnumLanternMetal>();
    }
}

