/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.lantern;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mods.railcraft.client.particles.ParticleHelper;
import mods.railcraft.common.blocks.aesthetics.lantern.LanternInfo;
import mods.railcraft.common.blocks.aesthetics.lantern.LanternProxy;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class BlockLantern
extends Block {
    public static boolean useCandleIcon = false;
    private static final float SELECT = 0.125f;
    static BlockLantern stone;
    static BlockLantern metal;
    private final int renderId;
    public IIcon candleIcon;
    public final LanternProxy proxy;

    public static BlockLantern getBlockStone() {
        return stone;
    }

    public static BlockLantern getBlockMetal() {
        return metal;
    }

    public BlockLantern(int renderId, LanternProxy proxy) {
        super(Material.redstoneLight);
        this.renderId = renderId;
        this.setStepSound(Block.soundTypeStone);
        this.proxy = proxy;
        this.setCreativeTab(CreativePlugin.RAILCRAFT_TAB);
        this.setHardness(5.0f);
        this.setResistance(15.0f);
        this.opaque = false;
        this.lightOpacity = 0;
        this.setLightLevel(0.9375f);
        this.setHarvestLevel("pickaxe", 0);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        int meta = world.getBlockMetadata(x, y, z);
        return new ItemStack((Block)this, 1, meta);
    }

    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        for (LanternInfo lanternInfo : this.proxy.getCreativeList()) {
            if (!lanternInfo.isEnabled()) continue;
            list.add(lanternInfo.getItem());
        }
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        return AxisAlignedBB.getBoundingBox((double)((float)x + 0.125f), (double)((float)y + 0.125f), (double)((float)z + 0.125f), (double)((float)(x + 1) - 0.125f), (double)((float)y + 1.0f - 0.0625f), (double)((float)(z + 1) - 0.125f));
    }

    public void randomDisplayTick(World world, int x, int y, int z, Random par5Random) {
        double dx = (float)x + 0.5f;
        double dy = (float)y + 0.65f;
        double dz = (float)z + 0.5f;
        world.spawnParticle("smoke", dx, dy, dz, 0.0, 0.0, 0.0);
        world.spawnParticle("flame", dx, dy, dz, 0.0, 0.0, 0.0);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isBlockNormalCube() {
        return false;
    }

    public int damageDropped(int meta) {
        return meta;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 1;
    }

    public int getRenderType() {
        return this.renderId;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (useCandleIcon) {
            return this.candleIcon;
        }
        return this.proxy.fromOrdinal(meta).getTexture(side);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return ParticleHelper.addHitEffects(worldObj, this, target, effectRenderer, null);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World worldObj, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return ParticleHelper.addDestroyEffects(worldObj, this, x, y, z, meta, effectRenderer, null);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.candleIcon = iconRegister.registerIcon("railcraft:stonelamp.candle");
    }
}

