/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.glass;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.aesthetics.glass.ItemStrengthGlass;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.plugins.misc.MicroBlockPlugin;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockStrengthGlass
extends BlockGlass {
    private static BlockStrengthGlass instance;
    public static boolean renderingHighlight;
    private final int renderId;
    private IIcon[] icons;
    private final Map<EnumSet<Neighbors>, IIcon> patterns = new HashMap<EnumSet<Neighbors>, IIcon>();

    public static BlockStrengthGlass getBlock() {
        return instance;
    }

    public static void registerBlock() {
        if (instance == null && RailcraftConfig.isBlockEnabled("glass")) {
            instance = new BlockStrengthGlass(Railcraft.proxy.getRenderId());
            RailcraftRegistry.register((Block)instance, ItemStrengthGlass.class);
            ForestryPlugin.addBackpackItem("builder", (Block)instance);
            for (int meta = 0; meta < 16; ++meta) {
                MicroBlockPlugin.addMicroBlockCandidate((Block)instance, meta);
            }
        }
    }

    public static ItemStack getItem(int meta) {
        return BlockStrengthGlass.getItem(1, meta);
    }

    public static ItemStack getItem(int qty, int meta) {
        if (instance == null) {
            return null;
        }
        return new ItemStack((Block)instance, qty, meta);
    }

    public BlockStrengthGlass(int renderId) {
        super(Material.glass, false);
        this.renderId = renderId;
        this.setResistance(5.0f);
        this.setHardness(1.0f);
        this.setStepSound(Block.soundTypeGlass);
        this.setCreativeTab(CreativePlugin.RAILCRAFT_TAB);
        this.setBlockName("railcraft.glass");
    }

    public int getRenderType() {
        return this.renderId;
    }

    public int damageDropped(int meta) {
        return meta;
    }

    protected boolean canSilkHarvest() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.icons = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:glass", 1, 5);
        this.patterns.put(EnumSet.noneOf(Neighbors.class), this.icons[0]);
        this.patterns.put(EnumSet.of(Neighbors.BOTTOM), this.icons[1]);
        this.patterns.put(EnumSet.of(Neighbors.TOP, Neighbors.BOTTOM), this.icons[2]);
        this.patterns.put(EnumSet.of(Neighbors.TOP), this.icons[3]);
    }

    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        if (renderingHighlight) {
            return this.icons[4];
        }
        if (side <= 1) {
            return this.icons[0];
        }
        int meta = world.getBlockMetadata(x, y, z);
        EnumSet<Neighbors> neighbors = EnumSet.noneOf(Neighbors.class);
        if (WorldPlugin.getBlock(world, x, y + 1, z) == this && world.getBlockMetadata(x, y + 1, z) == meta) {
            neighbors.add(Neighbors.TOP);
        }
        if (WorldPlugin.getBlock(world, x, y - 1, z) == this && world.getBlockMetadata(x, y - 1, z) == meta) {
            neighbors.add(Neighbors.BOTTOM);
        }
        return this.patterns.get(neighbors);
    }

    public IIcon getIcon(int side, int meta) {
        if (renderingHighlight) {
            return this.icons[4];
        }
        return this.icons[0];
    }

    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        for (int meta = 0; meta < 16; ++meta) {
            list.add(new ItemStack(item, 1, meta));
        }
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int colour) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta != colour) {
            world.setBlockMetadataWithNotify(x, y, z, colour, 3);
            return true;
        }
        return false;
    }

    public int colorMultiplier(IBlockAccess world, int x, int y, int z) {
        if (renderingHighlight) {
            return super.colorMultiplier(world, x, y, z);
        }
        int meta = world.getBlockMetadata(x, y, z);
        return EnumColor.fromId(15 - meta).getHexColor();
    }

    private static enum Neighbors {
        TOP,
        BOTTOM;

    }
}

