/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.util.textures;

import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.io.IOException;
import javax.imageio.ImageIO;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class TextureAtlasSheet
extends TextureAtlasSprite {
    private final int index;
    private final int rows;
    private final int columns;

    public static IIcon[] unstitchIcons(IIconRegister iconRegister, String name, int numIcons) {
        return TextureAtlasSheet.unstitchIcons(iconRegister, name, numIcons, 1);
    }

    public static IIcon[] unstitchIcons(IIconRegister iconRegister, String name, int columns, int rows) {
        TextureMap textureMap = (TextureMap)iconRegister;
        int numIcons = rows * columns;
        IIcon[] icons = new IIcon[numIcons];
        for (int i = 0; i < numIcons; ++i) {
            String texName = name + "." + i;
            TextureAtlasSheet texture = new TextureAtlasSheet(texName, i, rows, columns);
            textureMap.setTextureEntry(texName, (TextureAtlasSprite)texture);
            icons[i] = texture;
        }
        return icons;
    }

    private TextureAtlasSheet(String name, int index, int rows, int columns) {
        super(name);
        this.index = index;
        this.rows = rows;
        this.columns = columns;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(IResourceManager manager, ResourceLocation location) {
        BufferedImage subImage;
        BufferedImage image;
        int split = (location = new ResourceLocation(location.getResourceDomain(), location.getResourcePath().replace("." + this.index, ""))).getResourcePath().indexOf(58);
        if (split != -1) {
            location = new ResourceLocation(location.getResourceDomain(), location.getResourcePath().substring(0, split));
        }
        location = new ResourceLocation(location.getResourceDomain(), "textures/blocks/" + location.getResourcePath() + ".png");
        IResource resource = null;
        try {
            resource = manager.getResource(location);
            image = ImageIO.read(resource.getInputStream());
        }
        catch (IOException ex) {
            Game.log(Level.WARN, "Failed to load sub-texture from {0}: {1}", location.getResourcePath(), ex.getLocalizedMessage());
            boolean bl = true;
            return bl;
        }
        finally {
            if (resource != null) {
                try {
                    resource.getInputStream().close();
                }
                catch (IOException iOException) {}
            }
        }
        int mipmapLevels = Minecraft.getMinecraft().gameSettings.mipmapLevels;
        int size = image.getHeight() / this.rows;
        int x = this.index % this.columns;
        int y = this.index / this.columns;
        try {
            subImage = image.getSubimage(x * size, y * size, size, size);
        }
        catch (RasterFormatException ex) {
            Game.log(Level.WARN, "Failed to load sub-texture from {0} - {1}x{2}: {3}", location.getResourcePath(), image.getWidth(), image.getHeight(), ex.getLocalizedMessage());
            return true;
        }
        this.height = subImage.getHeight();
        this.width = subImage.getWidth();
        int[] rgbaData = new int[this.height * this.width];
        subImage.getRGB(0, 0, this.width, this.height, rgbaData, 0, this.width);
        int[][] imageData = new int[1 + mipmapLevels][];
        imageData[0] = rgbaData;
        this.framesTextureData.add(imageData);
        return false;
    }
}

