/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render.carts;

import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.client.render.carts.CartContentRenderer;
import mods.railcraft.client.render.carts.RenderCart;
import mods.railcraft.common.carts.EntityCartRF;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class CartContentRendererRedstoneFlux
extends CartContentRenderer {
    private static final CartContentRendererRedstoneFlux instance = new CartContentRendererRedstoneFlux();
    private final RenderFakeBlock.RenderInfo redBlock = new RenderFakeBlock.RenderInfo();
    private final RenderFakeBlock.RenderInfo leadFrame = new RenderFakeBlock.RenderInfo();

    private CartContentRendererRedstoneFlux() {
    }

    public static CartContentRendererRedstoneFlux instance() {
        return instance;
    }

    public void setRedstoneIcon(IIcon icon) {
        this.redBlock.override = icon;
    }

    public void setFrameIcon(IIcon icon) {
        this.leadFrame.override = icon;
    }

    @Override
    public void render(RenderCart renderer, EntityMinecart cart, float light, float time) {
        super.render(renderer, cart, light, time);
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glTranslatef((float)0.0f, (float)0.3125f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int x = (int)Math.floor(cart.posX);
        int y = (int)Math.floor(cart.posY);
        int z = (int)Math.floor(cart.posZ);
        EntityCartRF cartRF = (EntityCartRF)cart;
        renderer.bindTex(TextureMap.locationBlocksTexture);
        GL11.glTranslatef((float)0.0f, (float)0.0625f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderFakeBlock.renderBlockForEntity(this.leadFrame, (IBlockAccess)cart.worldObj, x, y, z, false, true);
        float scale = 0.99f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        float bright = 0.5f + 0.5f * (float)((double)cartRF.getRF() / (double)cartRF.getMaxRF());
        GL11.glColor4f((float)bright, (float)bright, (float)bright, (float)1.0f);
        RenderFakeBlock.renderBlockForEntity(this.redBlock, (IBlockAccess)cart.worldObj, x, y, z, false, true);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }
}

