/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Vec3;

public class TexturedQuadAdv
extends TexturedQuad {
    private int r;
    private int g;
    private int b;
    private int a;
    private int brightness;
    private boolean doTesselating = true;

    public TexturedQuadAdv(PositionTextureVertex[] verts) {
        super(verts);
    }

    public void setColorRGBA(int r, int g, int b, int a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public void setBrightness(int brightness) {
        this.brightness = brightness;
    }

    public void setDoTesselating(boolean doTess) {
        this.doTesselating = doTess;
    }

    public void draw(Tessellator tess, float par2) {
        Vec3 vec3 = this.vertexPositions[1].vector3D.subtract(this.vertexPositions[0].vector3D);
        Vec3 vec31 = this.vertexPositions[1].vector3D.subtract(this.vertexPositions[2].vector3D);
        Vec3 vec32 = vec31.crossProduct(vec3).normalize();
        if (this.doTesselating) {
            tess.startDrawingQuads();
        }
        tess.setColorRGBA(this.r, this.g, this.b, this.a);
        tess.setBrightness(this.brightness);
        tess.setNormal((float)vec32.xCoord, (float)vec32.yCoord, (float)vec32.zCoord);
        for (int i = 0; i < 4; ++i) {
            PositionTextureVertex positiontexturevertex = this.vertexPositions[i];
            tess.addVertexWithUV((double)((float)positiontexturevertex.vector3D.xCoord * par2), (double)((float)positiontexturevertex.vector3D.yCoord * par2), (double)((float)positiontexturevertex.vector3D.zCoord * par2), (double)positiontexturevertex.texturePositionX, (double)positiontexturevertex.texturePositionY);
        }
        if (this.doTesselating) {
            tess.draw();
        }
    }
}

