/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import mods.railcraft.client.render.BlockRenderer;
import mods.railcraft.common.blocks.aesthetics.wall.BlockRailcraftWall;
import mods.railcraft.common.blocks.aesthetics.wall.EnumWallAlpha;
import mods.railcraft.common.blocks.aesthetics.wall.WallInfo;
import net.minecraft.block.Block;
import net.minecraft.block.BlockWall;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderWall
extends BlockRenderer {
    public RenderWall(Block block) {
        super(block);
    }

    @Override
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderBlocks) {
        int meta = world.getBlockMetadata(x, y, z);
        WallInfo wall = ((BlockRailcraftWall)block).proxy.fromMeta(meta);
        if (this.canRenderInPass(renderBlocks, wall)) {
            renderBlocks.renderBlockWall((BlockWall)block, x, y, z);
            return true;
        }
        return false;
    }

    private boolean canRenderInPass(RenderBlocks renderer, WallInfo wall) {
        int pass = BlockRailcraftWall.currentRenderPass;
        return renderer.hasOverrideBlockTexture() || pass == 1 == (wall == EnumWallAlpha.ICE);
    }

    @Override
    public void renderItem(RenderBlocks renderBlocks, ItemStack item, IItemRenderer.ItemRenderType renderType) {
        Block block = this.getBlock();
        int meta = item.getItemDamage();
        renderBlocks.setRenderBoundsFromBlock(block);
        Tessellator tess = Tessellator.instance;
        for (int i = 0; i < 2; ++i) {
            if (i == 0) {
                renderBlocks.setRenderBounds(0.0, 0.0, 0.3125, 1.0, 0.8125, 0.6875);
            }
            if (i == 1) {
                renderBlocks.setRenderBounds(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
            }
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tess.startDrawingQuads();
            tess.setNormal(0.0f, -1.0f, 0.0f);
            IIcon icon = block.getIcon(0, meta);
            if (icon != null) {
                renderBlocks.renderFaceYNeg(block, 0.0, 0.0, 0.0, icon);
            }
            tess.draw();
            tess.startDrawingQuads();
            tess.setNormal(0.0f, 1.0f, 0.0f);
            icon = block.getIcon(1, meta);
            if (icon != null) {
                renderBlocks.renderFaceYPos(block, 0.0, 0.0, 0.0, icon);
            }
            tess.draw();
            tess.startDrawingQuads();
            tess.setNormal(0.0f, 0.0f, -1.0f);
            icon = block.getIcon(2, meta);
            if (icon != null) {
                renderBlocks.renderFaceZNeg(block, 0.0, 0.0, 0.0, icon);
            }
            tess.draw();
            tess.startDrawingQuads();
            tess.setNormal(0.0f, 0.0f, 1.0f);
            icon = block.getIcon(3, meta);
            if (icon != null) {
                renderBlocks.renderFaceZPos(block, 0.0, 0.0, 0.0, icon);
            }
            tess.draw();
            tess.startDrawingQuads();
            tess.setNormal(-1.0f, 0.0f, 0.0f);
            icon = block.getIcon(4, meta);
            if (icon != null) {
                renderBlocks.renderFaceXNeg(block, 0.0, 0.0, 0.0, icon);
            }
            tess.draw();
            tess.startDrawingQuads();
            tess.setNormal(1.0f, 0.0f, 0.0f);
            icon = block.getIcon(5, meta);
            if (icon != null) {
                renderBlocks.renderFaceXPos(block, 0.0, 0.0, 0.0, icon);
            }
            tess.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
        renderBlocks.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }
}

