/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import mods.railcraft.common.blocks.machine.alpha.TileSteamTurbine;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class RenderTurbineGauge
extends TileEntitySpecialRenderer {
    public void renderTileEntityAt(TileEntity tile, double x, double y, double z, float partialTicks) {
        TileSteamTurbine turbine = (TileSteamTurbine)tile;
        if (!turbine.isStructureValid() || turbine.getPatternMarker() != 'W') {
            return;
        }
        double halfWidth = 0.03125;
        double len = 0.26;
        double zOffset = 0.001;
        double value = turbine.mainGauge = (turbine.mainGauge * 14.0 + (double)turbine.getMainGauge()) / 15.0;
        double angle = Math.toRadians(90.0 * value + 45.0);
        int fx = 0;
        int fz = 0;
        int rx = 0;
        int rz = 0;
        if (turbine.getPatternIndex() == 0) {
            if (turbine.getPatternPositionX() == 1) {
                fx = -1;
                rz = 1;
            } else if (turbine.getPatternPositionX() == 2) {
                x += 1.0;
                z += 1.0;
                fx = 1;
                rz = -1;
            }
        } else if (turbine.getPatternIndex() == 1) {
            if (turbine.getPatternPositionZ() == 1) {
                x += 1.0;
                fz = -1;
                rx = -1;
            } else if (turbine.getPatternPositionZ() == 2) {
                z += 1.0;
                fz = 1;
                rx = 1;
            }
        }
        if (fx == 0 && fz == 0 || rx == 0 && rz == 0) {
            throw new IllegalStateException("can't detect gauge orientation");
        }
        int lmCoords = tile.getWorldObj().getLightBrightnessForSkyBlocks(tile.xCoord + fx, tile.yCoord, tile.zCoord + fz, 0);
        int lmX = lmCoords % 65536;
        int lmY = lmCoords / 65536;
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)((float)lmX / 1.0f), (float)((float)lmY / 1.0f));
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setTranslation(x + (double)rx * 0.5 + (double)fx * zOffset, y + 0.5, z + (double)rz * 0.5 + (double)fz * zOffset);
        tessellator.setColorRGBA(100, 0, 0, 255);
        double cosA = Math.cos(angle);
        double sinA = Math.sin(angle);
        double glx = cosA * len;
        double gly = sinA * len;
        double gwx = sinA * halfWidth;
        double gwy = cosA * halfWidth;
        double baseOffset = 1.0 / Math.sin(angle) * halfWidth;
        tessellator.addVertex((double)(-rx) * baseOffset, 0.0, (double)(-rz) * baseOffset);
        tessellator.addVertex((double)rx * baseOffset, 0.0, (double)rz * baseOffset);
        tessellator.addVertex((double)(-rx) * glx + (double)rx * gwx, gly + gwy, (double)(-rz) * glx + (double)rz * gwx);
        tessellator.addVertex((double)(-rx) * glx - (double)rx * gwx, gly - gwy, (double)(-rz) * glx - (double)rz * gwx);
        tessellator.draw();
        tessellator.setTranslation(0.0, 0.0, 0.0);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
    }
}

