/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderTools {
    public static final int BOX_BRIGHTNESS = 165;
    public static final float PIXEL = 0.0625f;

    public static void setColor(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static boolean renderStandardBlock(RenderBlocks renderblocks, Block block, int x, int y, int z) {
        renderblocks.setRenderBoundsFromBlock(block);
        return renderblocks.renderStandardBlock(block, x, y, z);
    }

    public static boolean renderStandardBlockWithColorMultiplier(RenderBlocks renderblocks, Block block, int x, int y, int z) {
        renderblocks.setRenderBoundsFromBlock(block);
        int mult = block.colorMultiplier(renderblocks.blockAccess, x, y, z);
        float r = (float)(mult >> 16 & 0xFF) / 255.0f;
        float g = (float)(mult >> 8 & 0xFF) / 255.0f;
        float b = (float)(mult & 0xFF) / 255.0f;
        if (EntityRenderer.anaglyphEnable) {
            float var9 = (r * 30.0f + g * 59.0f + b * 11.0f) / 100.0f;
            float var10 = (r * 30.0f + g * 70.0f) / 100.0f;
            float var11 = (r * 30.0f + b * 70.0f) / 100.0f;
            r = var9;
            g = var10;
            b = var11;
        }
        return renderblocks.renderStandardBlockWithColorMultiplier(block, x, y, z, r, g, b);
    }

    public static void renderBlockSideWithBrightness(RenderBlocks renderblocks, IBlockAccess world, Block block, int i, int j, int k, int side, int brightness) {
        renderblocks.setRenderBoundsFromBlock(block);
        renderblocks.enableAO = false;
        Tessellator tessellator = Tessellator.instance;
        tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        tessellator.setBrightness(brightness);
        if (side == 0) {
            renderblocks.renderFaceYNeg(block, (double)i, (double)j, (double)k, block.getIcon(world, i, j, k, 0));
        } else if (side == 1) {
            renderblocks.renderFaceYPos(block, (double)i, (double)j, (double)k, block.getIcon(world, i, j, k, 1));
        } else if (side == 2) {
            renderblocks.renderFaceZNeg(block, (double)i, (double)j, (double)k, block.getIcon(world, i, j, k, 2));
        } else if (side == 3) {
            renderblocks.renderFaceZPos(block, (double)i, (double)j, (double)k, block.getIcon(world, i, j, k, 3));
        } else if (side == 4) {
            renderblocks.renderFaceXNeg(block, (double)i, (double)j, (double)k, block.getIcon(world, i, j, k, 4));
        } else if (side == 5) {
            renderblocks.renderFaceXPos(block, (double)i, (double)j, (double)k, block.getIcon(world, i, j, k, 5));
        }
    }

    public static void renderBlockOnInventory(RenderBlocks renderblocks, Block block, int meta, float light) {
        RenderTools.renderBlockOnInventory(renderblocks, block, meta, light, -1);
    }

    public static void renderBlockOnInventory(RenderBlocks renderblocks, Block block, int meta, float light, int side) {
        RenderTools.renderBlockOnInventory(renderblocks, block, meta, light, side, null);
    }

    public static void renderBlockOnInventory(RenderBlocks renderblocks, Block block, int meta, float light, int side, IIcon iconOveride) {
        IIcon icon;
        Tessellator tessellator = Tessellator.instance;
        block.setBlockBoundsForItemRender();
        renderblocks.setRenderBoundsFromBlock(block);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        if (side == 0 || side == -1) {
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            IIcon iIcon = icon = iconOveride == null ? block.getIcon(0, meta) : iconOveride;
            if (icon != null) {
                renderblocks.renderFaceYNeg(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.draw();
        }
        if (side == 1 || side == -1) {
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            IIcon iIcon = icon = iconOveride == null ? block.getIcon(1, meta) : iconOveride;
            if (icon != null) {
                renderblocks.renderFaceYPos(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.draw();
        }
        if (side == 2 || side == -1) {
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            IIcon iIcon = icon = iconOveride == null ? block.getIcon(2, meta) : iconOveride;
            if (icon != null) {
                renderblocks.renderFaceZNeg(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.draw();
        }
        if (side == 3 || side == -1) {
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            IIcon iIcon = icon = iconOveride == null ? block.getIcon(3, meta) : iconOveride;
            if (icon != null) {
                renderblocks.renderFaceZPos(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.draw();
        }
        if (side == 4 || side == -1) {
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            IIcon iIcon = icon = iconOveride == null ? block.getIcon(4, meta) : iconOveride;
            if (icon != null) {
                renderblocks.renderFaceXNeg(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.draw();
        }
        if (side == 5 || side == -1) {
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            IIcon iIcon = icon = iconOveride == null ? block.getIcon(5, meta) : iconOveride;
            if (icon != null) {
                renderblocks.renderFaceXPos(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.draw();
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public static IIcon getSafeIcon(IIcon icon) {
        if (icon == null) {
            return RenderTools.getMissingIcon();
        }
        return icon;
    }

    public static IIcon getMissingIcon() {
        return ((TextureMap)Minecraft.getMinecraft().getTextureManager().getTexture(TextureMap.locationBlocksTexture)).getAtlasSprite("missingno");
    }

    public static void renderString(String name, double xOffset, double yOffset, double zOffset) {
        RenderManager rm = RenderManager.instance;
        FontRenderer fontrenderer = rm.getFontRenderer();
        float f = 1.6f;
        float f1 = 0.016666668f * f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)xOffset), (float)((float)yOffset), (float)((float)zOffset));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-rm.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)rm.playerViewX, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)3553);
        tessellator.startDrawingQuads();
        int j = fontrenderer.getStringWidth(name) / 2;
        tessellator.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
        tessellator.addVertex((double)(-j - 1), -1.0, 0.0);
        tessellator.addVertex((double)(-j - 1), 8.0, 0.0);
        tessellator.addVertex((double)(j + 1), 8.0, 0.0);
        tessellator.addVertex((double)(j + 1), -1.0, 0.0);
        tessellator.draw();
        GL11.glEnable((int)3553);
        fontrenderer.drawString(name, -fontrenderer.getStringWidth(name) / 2, 0, 0x20FFFFFF);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        fontrenderer.drawString(name, -fontrenderer.getStringWidth(name) / 2, 0, -1);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }
}

