/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import mods.railcraft.api.tracks.ISwitchDevice;
import mods.railcraft.client.render.ICombinedRenderer;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.common.blocks.signals.BlockSignalRailcraft;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.TileSwitchBase;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderSwitch
implements ICombinedRenderer {
    private static final float PIX = 0.0625f;
    private static final int LEVER_HEIGHT = 10;
    private EnumSignal type;
    private RenderFakeBlock.RenderInfo info = new RenderFakeBlock.RenderInfo();

    public RenderSwitch(EnumSignal signal) {
        this.type = signal;
        this.info.texture = new IIcon[6];
    }

    @Override
    public void renderBlock(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z, Block block) {
        TileSwitchBase tile = (TileSwitchBase)world.getTileEntity(x, y, z);
        boolean powered = false;
        byte facing = 0;
        if (tile != null) {
            facing = tile.getFacing();
            powered = tile.isPowered();
        }
        this.setTextureCore();
        float f = 0.25f;
        float f1 = 0.75f;
        this.info.setBlockBounds(f, 0.0f, f, f1, 0.3125f, f1);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        f = 0.4375f;
        f1 = 0.5625f;
        this.info.setBlockBounds(f, 0.0f, f, f1, 0.5f, f1);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(f, 0.6875f, f, f1, 0.75f, f1);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.setTextureExtension();
        if (facing == 2 || facing == 3) {
            this.info.setBlockBounds(0.374375f, 0.0f, 0.0f, 0.625625f, 0.188125f, 1.0f);
            RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        } else {
            this.info.setBlockBounds(0.0f, 0.0f, 0.374375f, 1.0f, 0.188125f, 0.625625f);
            RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        }
        if (tile == null) {
            this.setTextureWhite();
            this.renderTargetNorthSouth(renderblocks, world, x, y, z);
            this.setTextureRed();
            this.renderTargetEastWest(renderblocks, world, x, y, z);
            return;
        }
        this.setTextureWhite();
        ISwitchDevice.ArrowDirection whiteArrow = tile.getWhiteArrowRenderState();
        this.renderTarget(whiteArrow, renderblocks, world, x, y, z);
        this.setTextureRed();
        ISwitchDevice.ArrowDirection redArrow = tile.getRedArrowRenderState();
        this.renderTarget(redArrow, renderblocks, world, x, y, z);
        if (this.type == EnumSignal.SWITCH_LEVER) {
            this.renderLever(x, y, z, facing, powered);
        }
    }

    private void setTextureCore() {
        IIcon icon;
        this.info.texture[0] = BlockSignalRailcraft.texturesSwitch[0];
        this.info.texture[1] = BlockSignalRailcraft.texturesSwitch[0];
        this.info.texture[2] = icon = this.type.getIcon();
        this.info.texture[3] = icon;
        this.info.texture[4] = icon;
        this.info.texture[5] = icon;
    }

    private void setTextureExtension() {
        this.info.texture[0] = BlockSignalRailcraft.texturesSwitch[0];
        this.info.texture[1] = BlockSignalRailcraft.texturesSwitch[0];
        this.info.texture[2] = BlockSignalRailcraft.texturesSwitch[1];
        this.info.texture[3] = BlockSignalRailcraft.texturesSwitch[1];
        this.info.texture[4] = BlockSignalRailcraft.texturesSwitch[1];
        this.info.texture[5] = BlockSignalRailcraft.texturesSwitch[1];
    }

    private void setTextureWhite() {
        for (int i = 0; i < 6; ++i) {
            this.info.texture[i] = BlockSignalRailcraft.texturesSwitchTarget[0];
        }
    }

    private void setTextureRed() {
        for (int i = 0; i < 6; ++i) {
            this.info.texture[i] = BlockSignalRailcraft.texturesSwitchTarget[1];
        }
    }

    private void renderLever(double x, double y, double z, int facing, boolean thrown) {
        IIcon icon = BlockSignalRailcraft.texturesSwitchLever;
        float pix = 0.0625f;
        Tessellator tess = Tessellator.instance;
        Vec3[] vertices = new Vec3[8];
        float vx = pix;
        float vz = pix;
        float vy = pix * 10.0f;
        vertices[0] = Vec3.createVectorHelper((double)(-vx), (double)0.0, (double)(-vz));
        vertices[1] = Vec3.createVectorHelper((double)vx, (double)0.0, (double)(-vz));
        vertices[2] = Vec3.createVectorHelper((double)vx, (double)0.0, (double)vz);
        vertices[3] = Vec3.createVectorHelper((double)(-vx), (double)0.0, (double)vz);
        vertices[4] = Vec3.createVectorHelper((double)(-vx), (double)vy, (double)(-vz));
        vertices[5] = Vec3.createVectorHelper((double)vx, (double)vy, (double)(-vz));
        vertices[6] = Vec3.createVectorHelper((double)vx, (double)vy, (double)vz);
        vertices[7] = Vec3.createVectorHelper((double)(-vx), (double)vy, (double)vz);
        for (int i = 0; i < 8; ++i) {
            if (thrown) {
                vertices[i].zCoord -= 0.0625;
                vertices[i].rotateAroundX(0.69813174f);
            } else {
                vertices[i].zCoord += 0.0625;
                vertices[i].rotateAroundX(-0.69813174f);
            }
            vertices[i].xCoord += (double)(pix * 6.0f);
            if (facing == 2) {
                vertices[i].rotateAroundY(4.712389f);
            } else if (facing == 3) {
                vertices[i].rotateAroundY(1.5707964f);
            } else if (facing == 5) {
                vertices[i].rotateAroundY((float)Math.PI);
            }
            vertices[i].xCoord += x + 0.5;
            vertices[i].yCoord += y + 0.125;
            vertices[i].zCoord += z + 0.5;
        }
        double minU = icon.getInterpolatedU(7.0);
        double minV = icon.getInterpolatedV(6.0);
        double maxU = icon.getInterpolatedU(9.0);
        double maxV = icon.getInterpolatedV(8.0);
        for (int side = 0; side < 6; ++side) {
            Vec3 vertex4;
            Vec3 vertex3;
            Vec3 vertex2;
            Vec3 vertex1;
            if (side == 2) {
                maxV = icon.getMaxV();
            }
            if (side == 0) {
                vertex1 = vertices[0];
                vertex2 = vertices[1];
                vertex3 = vertices[2];
                vertex4 = vertices[3];
            } else if (side == 1) {
                vertex1 = vertices[7];
                vertex2 = vertices[6];
                vertex3 = vertices[5];
                vertex4 = vertices[4];
            } else if (side == 2) {
                vertex1 = vertices[1];
                vertex2 = vertices[0];
                vertex3 = vertices[4];
                vertex4 = vertices[5];
            } else if (side == 3) {
                vertex1 = vertices[2];
                vertex2 = vertices[1];
                vertex3 = vertices[5];
                vertex4 = vertices[6];
            } else if (side == 4) {
                vertex1 = vertices[3];
                vertex2 = vertices[2];
                vertex3 = vertices[6];
                vertex4 = vertices[7];
            } else {
                vertex1 = vertices[0];
                vertex2 = vertices[3];
                vertex3 = vertices[7];
                vertex4 = vertices[4];
            }
            tess.addVertexWithUV(vertex1.xCoord, vertex1.yCoord, vertex1.zCoord, minU, maxV);
            tess.addVertexWithUV(vertex2.xCoord, vertex2.yCoord, vertex2.zCoord, maxU, maxV);
            tess.addVertexWithUV(vertex3.xCoord, vertex3.yCoord, vertex3.zCoord, maxU, minV);
            tess.addVertexWithUV(vertex4.xCoord, vertex4.yCoord, vertex4.zCoord, minU, minV);
        }
    }

    private void renderTarget(ISwitchDevice.ArrowDirection arrow, RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z) {
        switch (arrow) {
            case NORTH: {
                this.renderTargetNorth(renderblocks, world, x, y, z);
                break;
            }
            case SOUTH: {
                this.renderTargetSouth(renderblocks, world, x, y, z);
                break;
            }
            case EAST: {
                this.renderTargetEast(renderblocks, world, x, y, z);
                break;
            }
            case WEST: {
                this.renderTargetWest(renderblocks, world, x, y, z);
                break;
            }
            case NORTH_SOUTH: {
                this.renderTargetNorthSouth(renderblocks, world, x, y, z);
                break;
            }
            case EAST_WEST: {
                this.renderTargetEastWest(renderblocks, world, x, y, z);
            }
        }
    }

    private void renderTargetNorthSouth(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z) {
        this.info.setBlockBounds(0.5f, 0.5f, 0.25f, 0.5625f, 0.6875f, 0.5f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.4375f, 0.5f, 0.5f, 0.5f, 0.6875f, 0.75f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
    }

    private void renderTargetEastWest(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z) {
        this.info.setBlockBounds(0.25f, 0.5f, 0.4375f, 0.5f, 0.6875f, 0.5f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.5f, 0.5f, 0.5f, 0.75f, 0.6875f, 0.5625f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
    }

    private void renderTargetNorth(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z) {
        this.info.setBlockBounds(0.5f, 0.5f, 0.25f, 0.5625f, 0.6875f, 0.5f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.4375f, 0.5f, 0.5f, 0.5f, 0.6875f, 0.75f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.5f, 0.5625f, 0.1875f, 0.5625f, 0.625f, 0.25f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.4375f, 0.5f, 0.75f, 0.5f, 0.5625f, 0.8125f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.4375f, 0.625f, 0.75f, 0.5f, 0.6875f, 0.8125f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
    }

    private void renderTargetSouth(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z) {
        this.info.setBlockBounds(0.5f, 0.5f, 0.25f, 0.5625f, 0.6875f, 0.5f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.4375f, 0.5f, 0.5f, 0.5f, 0.6875f, 0.75f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.4375f, 0.5625f, 0.75f, 0.5f, 0.625f, 0.8125f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.5f, 0.5f, 0.1875f, 0.5625f, 0.5625f, 0.25f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.5f, 0.625f, 0.1875f, 0.5625f, 0.6875f, 0.25f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
    }

    private void renderTargetEast(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z) {
        this.info.setBlockBounds(0.25f, 0.5f, 0.4375f, 0.5f, 0.6875f, 0.5f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.5f, 0.5f, 0.5f, 0.75f, 0.6875f, 0.5625f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.1875f, 0.5625f, 0.4375f, 0.25f, 0.625f, 0.5f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.75f, 0.5f, 0.5f, 0.8125f, 0.5625f, 0.5625f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.75f, 0.625f, 0.5f, 0.8125f, 0.6875f, 0.5625f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
    }

    private void renderTargetWest(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z) {
        this.info.setBlockBounds(0.25f, 0.5f, 0.4375f, 0.5f, 0.6875f, 0.5f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.5f, 0.5f, 0.5f, 0.75f, 0.6875f, 0.5625f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.75f, 0.5625f, 0.5f, 0.8125f, 0.625f, 0.5625f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.1875f, 0.5f, 0.4375f, 0.25f, 0.5625f, 0.5f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
        this.info.setBlockBounds(0.1875f, 0.625f, 0.4375f, 0.25f, 0.6875f, 0.5f);
        RenderFakeBlock.renderAsBlock(this.info, renderblocks, world, x, y, z);
    }

    @Override
    public void renderItem(RenderBlocks renderblocks, ItemStack item, IItemRenderer.ItemRenderType renderType) {
        switch (renderType) {
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: 
            case ENTITY: {
                float scale = 1.5f;
                GL11.glScalef((float)scale, (float)scale, (float)scale);
            }
        }
        this.setTextureCore();
        float min = 0.25f;
        float max = 0.75f;
        this.info.setBlockBounds(min, 0.0f, min, max, 0.3125f, max);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        min = 0.4375f;
        max = 0.5625f;
        this.info.setBlockBounds(min, 0.0f, min, max, 0.5f, max);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.info.setBlockBounds(min, 0.6875f, min, max, 0.75f, max);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.setTextureExtension();
        this.info.setBlockBounds(0.375f, 0.0f, 0.0f, 0.625f, 0.1875f, 1.0f);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.setTextureRed();
        this.info.setBlockBounds(0.25f, 0.5f, 0.4375f, 0.5f, 0.6875f, 0.5f);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.info.setBlockBounds(0.5f, 0.5f, 0.5f, 0.75f, 0.6875f, 0.5625f);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.info.setBlockBounds(0.75f, 0.5625f, 0.5f, 0.8125f, 0.625f, 0.5625f);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.info.setBlockBounds(0.1875f, 0.5f, 0.4375f, 0.25f, 0.5625f, 0.5f);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.info.setBlockBounds(0.1875f, 0.625f, 0.4375f, 0.25f, 0.6875f, 0.5f);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.setTextureWhite();
        this.info.setBlockBounds(0.5f, 0.5f, 0.25f, 0.5625f, 0.6875f, 0.5f);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.info.setBlockBounds(0.4375f, 0.5f, 0.5f, 0.5f, 0.6875f, 0.75f);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        if (this.type == EnumSignal.SWITCH_LEVER) {
            Tessellator tess = Tessellator.instance;
            tess.startDrawingQuads();
            this.renderLever(-0.5, -0.5, -0.5, 3, false);
            tess.draw();
        }
    }
}

