/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import mods.railcraft.client.render.BlockRenderer;
import mods.railcraft.common.blocks.aesthetics.EnumBlockMaterial;
import mods.railcraft.common.blocks.aesthetics.stairs.BlockRailcraftStairs;
import mods.railcraft.common.blocks.aesthetics.stairs.TileStair;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderStair
extends BlockRenderer {
    public RenderStair() {
        super((Block)BlockRailcraftStairs.getBlock());
    }

    @Override
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderBlocks) {
        TileStair stair;
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileStair && this.canRenderInPass(renderBlocks, (stair = (TileStair)tile).getStair())) {
            renderBlocks.renderBlockStairs((BlockStairs)block, x, y, z);
            return true;
        }
        return false;
    }

    private boolean canRenderInPass(RenderBlocks renderer, EnumBlockMaterial stair) {
        int pass = BlockRailcraftStairs.currentRenderPass;
        return renderer.hasOverrideBlockTexture() || pass == 1 == (stair == EnumBlockMaterial.ICE);
    }

    @Override
    public void renderItem(RenderBlocks renderBlocks, ItemStack item, IItemRenderer.ItemRenderType renderType) {
        Block block = this.getBlock();
        int meta = item.getItemDamage();
        renderBlocks.setRenderBoundsFromBlock(block);
        Tessellator tess = Tessellator.instance;
        for (int k = 0; k < 2; ++k) {
            if (k == 0) {
                renderBlocks.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 0.5);
            }
            if (k == 1) {
                renderBlocks.setRenderBounds(0.0, 0.0, 0.5, 1.0, 0.5, 1.0);
            }
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tess.startDrawingQuads();
            tess.setNormal(0.0f, -1.0f, 0.0f);
            renderBlocks.renderFaceYNeg(block, 0.0, 0.0, 0.0, renderBlocks.getBlockIconFromSideAndMetadata(block, 0, meta));
            tess.draw();
            tess.startDrawingQuads();
            tess.setNormal(0.0f, 1.0f, 0.0f);
            renderBlocks.renderFaceYPos(block, 0.0, 0.0, 0.0, renderBlocks.getBlockIconFromSideAndMetadata(block, 1, meta));
            tess.draw();
            tess.startDrawingQuads();
            tess.setNormal(0.0f, 0.0f, -1.0f);
            renderBlocks.renderFaceZNeg(block, 0.0, 0.0, 0.0, renderBlocks.getBlockIconFromSideAndMetadata(block, 2, meta));
            tess.draw();
            tess.startDrawingQuads();
            tess.setNormal(0.0f, 0.0f, 1.0f);
            renderBlocks.renderFaceZPos(block, 0.0, 0.0, 0.0, renderBlocks.getBlockIconFromSideAndMetadata(block, 3, meta));
            tess.draw();
            tess.startDrawingQuads();
            tess.setNormal(-1.0f, 0.0f, 0.0f);
            renderBlocks.renderFaceXNeg(block, 0.0, 0.0, 0.0, renderBlocks.getBlockIconFromSideAndMetadata(block, 4, meta));
            tess.draw();
            tess.startDrawingQuads();
            tess.setNormal(1.0f, 0.0f, 0.0f);
            renderBlocks.renderFaceXPos(block, 0.0, 0.0, 0.0, renderBlocks.getBlockIconFromSideAndMetadata(block, 5, meta));
            tess.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
        renderBlocks.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }
}

