/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import mods.railcraft.client.render.FluidRenderer;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.machine.gamma.TileFluidLoader;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderFluidBase;
import mods.railcraft.common.fluids.tanks.StandardTank;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderFluidLoader
extends TileEntitySpecialRenderer {
    private static final float PIPE_OFFSET = 0.3125f;
    private static final RenderFakeBlock.RenderInfo backDrop = new RenderFakeBlock.RenderInfo();
    private static final RenderFakeBlock.RenderInfo pipe = new RenderFakeBlock.RenderInfo();

    public RenderFluidLoader() {
        RenderFluidLoader.backDrop.minX = 0.011f;
        RenderFluidLoader.backDrop.minY = 0.01f;
        RenderFluidLoader.backDrop.minZ = 0.011f;
        RenderFluidLoader.backDrop.maxX = 0.989f;
        RenderFluidLoader.backDrop.maxY = 0.99f;
        RenderFluidLoader.backDrop.maxZ = 0.989f;
        RenderFluidLoader.pipe.texture = EnumMachineGamma.pipeTexture;
        RenderFluidLoader.pipe.minX = 0.3125f;
        RenderFluidLoader.pipe.minZ = 0.3125f;
        RenderFluidLoader.pipe.maxX = 0.6875f;
        RenderFluidLoader.pipe.maxY = 0.0625f;
        RenderFluidLoader.pipe.maxZ = 0.6875f;
        RenderFluidLoader.backDrop.texture = new IIcon[1];
    }

    public void renderTileEntityAt(TileEntity tile, double x, double y, double z, float f) {
        int[] displayLists;
        TileLoaderFluidBase base = (TileLoaderFluidBase)tile;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        RenderFluidLoader.backDrop.texture[0] = base.getMachineType().getTexture(7);
        this.bindTexture(TextureMap.locationBlocksTexture);
        RenderFakeBlock.renderBlock(backDrop, (IBlockAccess)base.getWorld(), x, y, z, false, true);
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)1.0f, (float)0.6f, (float)1.0f);
        StandardTank tank = base.getTankManager().get(0);
        if (tank.renderData.fluid != null && tank.renderData.amount > 0 && (displayLists = FluidRenderer.getLiquidDisplayLists(tank.renderData.fluid)) != null) {
            GL11.glPushMatrix();
            if (FluidRenderer.getFluidTexture(tank.renderData.fluid, false) != null) {
                float cap = tank.getCapacity();
                float level = Math.min((float)tank.renderData.amount, cap) / cap;
                this.bindTexture(FluidRenderer.getFluidSheet(tank.renderData.fluid));
                FluidRenderer.setColorForTank(tank);
                GL11.glCallList((int)displayLists[(int)(level * 99.0f)]);
            }
            GL11.glPopMatrix();
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
        if (tile.getClass() == TileFluidLoader.class) {
            TileFluidLoader loader = (TileFluidLoader)tile;
            RenderFluidLoader.pipe.minY = 0.0625f - loader.getPipeLenght();
            RenderFakeBlock.renderBlock(pipe, (IBlockAccess)loader.getWorld(), x, y, z, false, true);
        }
    }
}

