/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import mods.railcraft.client.render.BlockRenderer;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.client.render.RenderTools;
import mods.railcraft.common.blocks.aesthetics.lantern.BlockLantern;
import mods.railcraft.common.blocks.aesthetics.post.BlockPostBase;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderBlockLamp
extends BlockRenderer {
    private static final float PIX = 0.0625f;
    private static final int BASE_BORDER = 4;
    private static final int BASE_HEIGHT = 4;
    private static final int BASE_THICKNESS = 2;
    private static final int CAPBASE_BORDER = 3;
    private static final int CAPBASE_HEIGHT = 12;
    private static final int CAPBASE_THICKNESS = 2;
    private static final int CAPTOP_BORDER = 5;
    private static final int CAPTOP_HEIGHT = 14;
    private static final int CAPTOP_THICKNESS = 1;
    private static final int CANDLE_BORDER = 7;
    private static final int CANDLE_HEIGHT = 6;
    private static final int CANDLE_THICKNESS = 2;
    private static final int PILLAR_BORDER = 6;
    private static final int PILLAR_HEIGHT = 0;
    private static final int PILLAR_THICKNESS = 4;
    private static final int CORNER_THICKNESS = 2;
    private final RenderFakeBlock.RenderInfo info = new RenderFakeBlock.RenderInfo();
    private final BlockLantern lantern;

    public RenderBlockLamp(BlockLantern block) {
        super(block);
        this.lantern = block;
    }

    @Override
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderblocks) {
        int[] conn;
        if (this.canConnect(world, x, y, z, ForgeDirection.DOWN)) {
            this.renderCenteredCube(x, y, z, block, renderblocks, 6, 0, 4);
        }
        this.renderCenteredCube(x, y, z, block, renderblocks, 4, 4, 2);
        BlockLantern.useCandleIcon = true;
        this.renderCenteredCube(x, y, z, block, renderblocks, 7, 6, 2);
        BlockLantern.useCandleIcon = false;
        this.renderCenteredCube(x, y, z, block, renderblocks, 3, 12, 2);
        this.renderCenteredCube(x, y, z, block, renderblocks, 5, 14, 1);
        int zero = 4;
        int one = 10;
        this.renderCornerPost(x, y, z, block, renderblocks, zero, zero);
        this.renderCornerPost(x, y, z, block, renderblocks, zero, one);
        this.renderCornerPost(x, y, z, block, renderblocks, one, zero);
        this.renderCornerPost(x, y, z, block, renderblocks, one, one);
        if (this.canConnect(world, x, y, z, ForgeDirection.NORTH)) {
            conn = new int[]{6, 0, 10, 6};
            this.renderConnector(x, y, z, block, renderblocks, conn[0], conn[1], conn[2], conn[3]);
        }
        if (this.canConnect(world, x, y, z, ForgeDirection.SOUTH)) {
            conn = new int[]{6, 10, 10, 16};
            this.renderConnector(x, y, z, block, renderblocks, conn[0], conn[1], conn[2], conn[3]);
        }
        if (this.canConnect(world, x, y, z, ForgeDirection.EAST)) {
            conn = new int[]{10, 6, 16, 10};
            this.renderConnector(x, y, z, block, renderblocks, conn[0], conn[1], conn[2], conn[3]);
        }
        if (this.canConnect(world, x, y, z, ForgeDirection.WEST)) {
            conn = new int[]{0, 6, 6, 10};
            this.renderConnector(x, y, z, block, renderblocks, conn[0], conn[1], conn[2], conn[3]);
        }
        block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return true;
    }

    private void renderCenteredCube(int x, int y, int z, Block block, RenderBlocks renderblocks, int border, int height, int thinkness) {
        block.setBlockBounds((float)border * 0.0625f, (float)height * 0.0625f, (float)border * 0.0625f, 1.0f - (float)border * 0.0625f, (float)height * 0.0625f + (float)thinkness * 0.0625f, 1.0f - (float)border * 0.0625f);
        RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
    }

    private void renderCornerPost(int x, int y, int z, Block block, RenderBlocks renderblocks, int xBase, int zBase) {
        block.setBlockBounds((float)xBase * 0.0625f, 0.375f, (float)zBase * 0.0625f, (float)xBase * 0.0625f + 0.125f, 0.75f, (float)zBase * 0.0625f + 0.125f);
        RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
    }

    private void renderConnector(int x, int y, int z, Block block, RenderBlocks renderblocks, int xMin, int zMin, int xMax, int zMax) {
        block.setBlockBounds((float)xMin * 0.0625f, 0.375f, (float)zMin * 0.0625f, (float)xMax * 0.0625f, 0.75f, (float)zMax * 0.0625f);
        RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
    }

    private boolean canConnect(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        Block block;
        int sz;
        int sy;
        int sx = MiscTools.getXOnSide(x, side);
        if (world.isSideSolid(sx, sy = MiscTools.getYOnSide(y, side), sz = MiscTools.getZOnSide(z, side), side.getOpposite(), false)) {
            return true;
        }
        if (side == ForgeDirection.DOWN) {
            if (World.doesBlockHaveSolidTopSurface((IBlockAccess)world, (int)sx, (int)sy, (int)sz)) {
                return true;
            }
            if (world instanceof ChunkCache && (block = WorldPlugin.getBlock(world, sx, sy, sz)) != null && block.canPlaceTorchOnTop((World)Minecraft.getMinecraft().theWorld, sx, sy, sz)) {
                return true;
            }
        }
        return (block = WorldPlugin.getBlock(world, sx, sy, sz)) instanceof BlockPostBase;
    }

    @Override
    public void renderItem(RenderBlocks renderblocks, ItemStack item, IItemRenderer.ItemRenderType renderType) {
        this.info.override = this.lantern.candleIcon;
        this.renderCenteredCubeItem(this.info, renderblocks, 7, 6, 2);
        this.info.override = item.getIconIndex();
        this.renderCenteredCubeItem(this.info, renderblocks, 6, 0, 4);
        this.renderCenteredCubeItem(this.info, renderblocks, 4, 4, 2);
        this.renderCenteredCubeItem(this.info, renderblocks, 3, 12, 2);
        this.renderCenteredCubeItem(this.info, renderblocks, 5, 14, 1);
        int zero = 4;
        int one = 10;
        this.renderCornerPostItem(this.info, renderblocks, zero, zero);
        this.renderCornerPostItem(this.info, renderblocks, zero, one);
        this.renderCornerPostItem(this.info, renderblocks, one, zero);
        this.renderCornerPostItem(this.info, renderblocks, one, one);
    }

    private void renderCenteredCubeItem(RenderFakeBlock.RenderInfo info, RenderBlocks renderblocks, int border, int height, int thinkness) {
        info.setBlockBounds((float)border * 0.0625f, (float)height * 0.0625f, (float)border * 0.0625f, 1.0f - (float)border * 0.0625f, (float)height * 0.0625f + (float)thinkness * 0.0625f, 1.0f - (float)border * 0.0625f);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, info, 1.0f);
    }

    private void renderCornerPostItem(RenderFakeBlock.RenderInfo info, RenderBlocks renderblocks, int xBase, int zBase) {
        info.setBlockBounds((float)xBase * 0.0625f, 0.375f, (float)zBase * 0.0625f, (float)xBase * 0.0625f + 0.125f, 0.75f, (float)zBase * 0.0625f + 0.125f);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, info, 1.0f);
    }
}

