/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.particles;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mods.railcraft.common.util.effects.EffectManager;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class EntityHeatTrailFX
extends EntityFX {
    private static Random colorRand = new Random();
    private final EffectManager.IEffectSource source;

    public EntityHeatTrailFX(World world, double x, double y, double z, long colorSeed, EffectManager.IEffectSource source) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.source = source;
        this.calculateVector();
        this.multipleParticleScaleBy(0.5f);
        colorRand.setSeed(colorSeed);
        this.particleRed = colorRand.nextFloat() * 0.8f + 0.2f;
        this.particleGreen = colorRand.nextFloat() * 0.8f + 0.2f;
        this.particleBlue = colorRand.nextFloat() * 0.8f + 0.2f;
        float varient = this.rand.nextFloat() * 0.6f + 0.4f;
        this.particleRed *= varient;
        this.particleGreen *= varient;
        this.particleBlue *= varient;
        this.particleMaxAge = 2000;
        this.noClip = true;
        this.setParticleTextureIndex((int)(Math.random() * 8.0));
    }

    private void calculateVector() {
        Vec3 endPoint = Vec3.createVectorHelper((double)this.source.getX(), (double)this.source.getY(), (double)this.source.getZ());
        Vec3 vecParticle = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
        Vec3 vel = vecParticle.subtract(endPoint);
        vel = vel.normalize();
        float velScale = 0.1f;
        this.motionX = vel.xCoord * (double)velScale;
        this.motionY = vel.yCoord * (double)velScale;
        this.motionZ = vel.zCoord * (double)velScale;
    }

    public int getBrightnessForRender(float par1) {
        int var2 = super.getBrightnessForRender(par1);
        float var3 = (float)this.particleAge / (float)this.particleMaxAge;
        var3 *= var3;
        var3 *= var3;
        int var4 = var2 & 0xFF;
        int var5 = var2 >> 16 & 0xFF;
        if ((var5 += (int)(var3 * 15.0f * 16.0f)) > 240) {
            var5 = 240;
        }
        return var4 | var5 << 16;
    }

    public float getBrightness(float par1) {
        float var2 = super.getBrightness(par1);
        float var3 = (float)this.particleAge / (float)this.particleMaxAge;
        var3 = var3 * var3 * var3 * var3;
        return var2 * (1.0f - var3) + var3;
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.source.isDead()) {
            this.setDead();
            return;
        }
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setDead();
            return;
        }
        if (this.getDistanceSq(this.source.getX(), this.source.getY(), this.source.getZ()) <= 0.1) {
            this.setDead();
            return;
        }
        if (this.source instanceof EffectManager.EffectSourceEntity) {
            this.calculateVector();
        }
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
    }
}

