/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import mods.railcraft.client.gui.TileGui;
import mods.railcraft.common.blocks.machine.alpha.TileAnchorWorld;
import mods.railcraft.common.gui.containers.ContainerAnchor;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.StatCollector;

public class GuiWorldAnchor
extends TileGui {
    private final TileAnchorWorld tile;
    private final ContainerAnchor container;

    public GuiWorldAnchor(InventoryPlayer playerInv, TileAnchorWorld anchor) {
        super(anchor, new ContainerAnchor(playerInv, anchor), "railcraft:textures/gui/gui_single_slot.png");
        this.xSize = 176;
        this.ySize = 140;
        this.tile = anchor;
        this.container = (ContainerAnchor)this.inventorySlots;
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        String label = this.tile.getName();
        int sWidth = this.fontRendererObj.getStringWidth(label);
        int sPos = this.xSize / 2 - sWidth / 2;
        this.fontRendererObj.drawString(label, sPos, 6, 0x404040);
        this.fontRendererObj.drawString(LocalizationPlugin.translate("railcraft.gui.anchor.fuel"), 85, 24, 0x404040);
        this.fontRendererObj.drawString(LocalizationPlugin.translate("railcraft.gui.anchor.fuel.remaining", (double)this.container.minutesRemaining / 60.0), 85, 35, 0x404040);
        this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"container.inventory"), 8, this.ySize - 96 + 2, 0x404040);
    }
}

