/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.buttons.GuiBetterButton;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.items.ItemTicket;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.network.PacketCurrentItemNBT;
import mods.railcraft.common.util.network.PacketDispatcher;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiTicket
extends GuiScreen {
    public static final ResourceLocation TEXTURE = new ResourceLocation("railcraft:textures/gui/ticket_gold.png");
    public static final int WRAP_WIDTH = 226;
    private final EntityPlayer player;
    private final ItemStack ticket;
    private boolean modified;
    private boolean readingManual;
    private int updateCount;
    private final int imageWidth = 256;
    private final int imageHeight = 136;
    private String dest = "";
    private GuiBetterButton buttonCancel;
    private GuiBetterButton buttonDone;
    private GuiBetterButton buttonHelp;

    public GuiTicket(EntityPlayer player, ItemStack stack) {
        this.player = player;
        this.ticket = stack;
        this.dest = ItemTicket.getDestination(this.ticket);
    }

    public void updateScreen() {
        super.updateScreen();
        ++this.updateCount;
    }

    public void initGui() {
        this.buttonList.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        ArrayList<GuiBetterButton> buttons = new ArrayList<GuiBetterButton>();
        this.buttonDone = new GuiBetterButton(0, 0, 161, 65, StatCollector.translateToLocal((String)"gui.done"));
        buttons.add(this.buttonDone);
        this.buttonHelp = new GuiBetterButton(1, 0, 161, 65, LocalizationPlugin.translate("railcraft.gui.help"));
        buttons.add(this.buttonHelp);
        this.buttonCancel = new GuiBetterButton(2, 0, 161, 65, StatCollector.translateToLocal((String)"gui.cancel"));
        buttons.add(this.buttonCancel);
        GuiTools.newButtonRowAuto(this.buttonList, this.width / 2 - 100, 200, buttons);
        this.updateButtons();
    }

    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private void updateButtons() {
        this.buttonHelp.displayString = this.readingManual ? StatCollector.translateToLocal((String)"gui.back") : LocalizationPlugin.translate("railcraft.gui.help");
    }

    private void sendToServer() {
        if (this.modified) {
            NBTTagCompound nbt = InvTools.getItemData(this.ticket);
            nbt.setString("dest", this.dest);
            if (!nbt.hasKey("owner")) {
                nbt.setString("owner", Railcraft.proxy.getPlayerUsername(this.player));
            }
            PacketCurrentItemNBT pkt = new PacketCurrentItemNBT(this.player, this.ticket);
            PacketDispatcher.sendToServer(pkt);
        }
    }

    protected void actionPerformed(GuiButton button) {
        if (button.enabled) {
            if (button == this.buttonCancel) {
                this.mc.displayGuiScreen((GuiScreen)null);
            } else if (button == this.buttonDone) {
                this.mc.displayGuiScreen((GuiScreen)null);
                this.sendToServer();
            } else if (button == this.buttonHelp) {
                this.readingManual = !this.readingManual;
            }
            this.updateButtons();
        }
    }

    protected void keyTyped(char c, int key) {
        super.keyTyped(c, key);
        switch (c) {
            case '\u0016': {
                this.dest = this.dest + GuiScreen.getClipboardString().replaceAll("\\s", "");
                this.modified = true;
                return;
            }
        }
        switch (key) {
            case 14: {
                if (this.dest.length() > 0) {
                    this.dest = this.dest.substring(0, this.dest.length() - 1);
                    this.modified = true;
                }
                return;
            }
        }
        if (!Character.isWhitespace(c) && ChatAllowedCharacters.isAllowedCharacter((char)c) && this.dest.length() + 1 < 32) {
            this.dest = this.dest + c;
            this.modified = true;
        }
    }

    public void drawScreen(int par1, int par2, float par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(TEXTURE);
        int xOffset = (this.width - this.imageWidth) / 2;
        int yOffset = 18;
        this.drawTexturedModalRect(xOffset, yOffset, 0, 0, this.imageWidth, this.imageHeight);
        if (this.readingManual) {
            GuiTools.drawCenteredString(this.fontRendererObj, LocalizationPlugin.translate("railcraft.gui.routing.ticket.manual.title"), yOffset + 14, this.width);
            String text = LocalizationPlugin.translate("railcraft.gui.routing.ticket.manual");
            this.fontRendererObj.drawSplitString(text, xOffset + 16, yOffset + 30, 226, 0);
        } else {
            GL11.glPushMatrix();
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            GuiTools.drawCenteredString(this.fontRendererObj, EnumChatFormatting.BOLD + LocalizationPlugin.translate("railcraft.gui.routing.ticket.title"), yOffset - 2, this.width / 2, 0xFFFFFF, true);
            GL11.glPopMatrix();
            GuiTools.drawCenteredString(this.fontRendererObj, LocalizationPlugin.translate("railcraft.gui.routing.ticket.line1"), yOffset + 50, this.width);
            GuiTools.drawCenteredString(this.fontRendererObj, LocalizationPlugin.translate("railcraft.gui.routing.ticket.line2"), yOffset + 65, this.width);
            String text = EnumChatFormatting.BLACK + "Dest=" + this.dest;
            text = this.fontRendererObj.getBidiFlag() ? text + "_" : (this.updateCount / 6 % 2 == 0 ? text + "" + EnumChatFormatting.BLACK + "_" : text + "" + EnumChatFormatting.GRAY + "_");
            this.fontRendererObj.drawSplitString(text, xOffset + 16, yOffset + 98, 226, 0);
        }
        super.drawScreen(par1, par2, par3);
    }
}

