/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.TileGui;
import mods.railcraft.client.gui.buttons.GuiMultiButton;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.signals.IRouter;
import mods.railcraft.common.blocks.signals.RoutingLogic;
import mods.railcraft.common.gui.buttons.LockButtonState;
import mods.railcraft.common.gui.containers.ContainerRouting;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.StatCollector;

public class GuiRouting
extends TileGui {
    private final IRouter router;
    private GuiMultiButton lockButton;
    private GuiMultiButton routingButton;
    private final EntityPlayer player;
    private final RailcraftTileEntity tile;
    private ToolTip lockedToolTips;
    private ToolTip unlockedToolTips;
    private ToolTip notownedToolTips;
    private ToolTip privateToolTips;
    private final ToolTip publicToolTips;
    private String ownerName = "[Unknown]";

    public GuiRouting(InventoryPlayer inv, RailcraftTileEntity tile, IRouter router) {
        super(tile, new ContainerRouting(inv, router), "railcraft:textures/gui/gui_routing.png");
        this.ySize = 160;
        this.tile = tile;
        this.router = router;
        this.player = inv.player;
        this.lockedToolTips = ToolTip.buildToolTip("railcraft.gui.tip.button.lock.locked", "{owner}=" + this.ownerName);
        this.unlockedToolTips = ToolTip.buildToolTip("railcraft.gui.tip.button.lock.unlocked", "{owner}=" + this.ownerName);
        this.notownedToolTips = ToolTip.buildToolTip("railcraft.gui.tip.button.lock.notowner", "{owner}=" + this.ownerName);
        this.privateToolTips = ToolTip.buildToolTip("railcraft.gui.routing.type.private.tip", "{owner}=" + this.ownerName);
        this.publicToolTips = ToolTip.buildToolTip("railcraft.gui.routing.type.public.tip", new String[0]);
    }

    public void initGui() {
        super.initGui();
        if (this.router == null) {
            return;
        }
        this.buttonList.clear();
        int w = (this.width - this.xSize) / 2;
        int h = (this.height - this.ySize) / 2;
        this.lockButton = new GuiMultiButton(8, w + 152, h + 8, 16, this.router.getLockController());
        this.buttonList.add(this.lockButton);
        this.lockButton.enabled = ((ContainerRouting)this.container).canLock;
        this.routingButton = new GuiMultiButton(8, w + 65, h + 50, 100, this.router.getRoutingController());
        this.buttonList.add(this.routingButton);
        this.routingButton.canChange = false;
    }

    protected void actionPerformed(GuiButton guibutton) {
        if (this.router == null) {
            return;
        }
        this.updateButtons();
    }

    public void updateScreen() {
        super.updateScreen();
        this.updateButtons();
        ContainerRouting con = (ContainerRouting)this.container;
        RoutingLogic logic = this.router.getLogic();
        con.errorElement.hidden = logic == null || logic.isValid();
    }

    private void updateButtons() {
        this.lockButton.enabled = ((ContainerRouting)this.container).canLock;
        this.routingButton.canChange = !this.router.isSecure() || ((ContainerRouting)this.container).canLock;
        String username = ((ContainerRouting)this.container).ownerName;
        if (username != null && !username.equals(this.ownerName)) {
            this.ownerName = username;
            this.lockedToolTips = ToolTip.buildToolTip("railcraft.gui.tip.button.lock.locked", "{owner}=" + username);
            this.unlockedToolTips = ToolTip.buildToolTip("railcraft.gui.tip.button.lock.unlocked", "{owner}=" + username);
            this.notownedToolTips = ToolTip.buildToolTip("railcraft.gui.tip.button.lock.notowner", "{owner}=" + username);
            this.privateToolTips = ToolTip.buildToolTip("railcraft.gui.routing.type.private.tip", "{owner}=" + username);
        }
        this.lockButton.setToolTip(this.router.getLockController().getButtonState() == LockButtonState.LOCKED ? this.lockedToolTips : (this.lockButton.enabled ? this.unlockedToolTips : this.notownedToolTips));
        this.routingButton.setToolTip(this.router.getRoutingController().getButtonState() == IRouter.RoutingButtonState.PRIVATE ? this.privateToolTips : this.publicToolTips);
    }

    public void onGuiClosed() {
        this.sendUpdatePacket();
    }

    private void sendUpdatePacket() {
        PacketBuilder.instance().sendGuiReturnPacket((IGuiReturnHandler)((Object)this.tile));
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        GuiTools.drawCenteredString(this.fontRendererObj, this.router.getName(), 6);
        this.fontRendererObj.drawString(LocalizationPlugin.translate("railcraft.gui.routing.slot.label"), 64, 29, 0x404040);
        this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"container.inventory"), 8, this.ySize - 96 + 2, 0x404040);
    }
}

