/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import java.util.ArrayList;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.TileGui;
import mods.railcraft.client.gui.buttons.GuiToggleButton;
import mods.railcraft.common.blocks.machine.gamma.TileRFLoader;
import mods.railcraft.common.gui.containers.ContainerLoaderRF;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.PacketGuiReturn;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.tileentity.TileEntity;

public class GuiLoaderRF
extends TileGui {
    private final String BUTTON1 = LocalizationPlugin.translate("railcraft.gui.energy.loader.empty");
    private final String BUTTON2 = LocalizationPlugin.translate("railcraft.gui.energy.loader.fill");
    private TileRFLoader tile;
    private boolean waitIfEmpty;
    private boolean waitTillFull;

    public GuiLoaderRF(TileRFLoader tile) {
        super(tile, new ContainerLoaderRF(tile), "railcraft:textures/gui/gui_rf_device.png");
        this.tile = tile;
        this.ySize = 88;
        this.waitIfEmpty = tile.waitIfEmpty();
        this.waitTillFull = tile.waitTillFull();
    }

    public void initGui() {
        super.initGui();
        if (this.tile == null) {
            return;
        }
        this.buttonList.clear();
        int w = (this.width - this.xSize) / 2;
        int h = (this.height - this.ySize) / 2;
        ArrayList<GuiToggleButton> buttons = new ArrayList<GuiToggleButton>();
        buttons.add(new GuiToggleButton(0, w + 75, h + 60, 70, this.BUTTON1, this.waitIfEmpty));
        buttons.add(new GuiToggleButton(1, w + 75, h + 60, 70, this.BUTTON2, this.waitTillFull));
        GuiTools.newButtonRowBookended(this.buttonList, w + 5, w + this.xSize - 5, buttons);
    }

    protected void actionPerformed(GuiButton guibutton) {
        if (this.tile == null) {
            return;
        }
        if (guibutton.id == 0) {
            boolean bl = this.waitIfEmpty = !this.waitIfEmpty;
            if (!this.waitIfEmpty) {
                this.waitTillFull = false;
            }
            ((GuiToggleButton)guibutton).active = this.waitIfEmpty;
            ((GuiToggleButton)((Object)this.buttonList.get((int)1))).active = this.waitTillFull;
        }
        if (guibutton.id == 1) {
            boolean bl = this.waitTillFull = !this.waitTillFull;
            if (this.waitTillFull) {
                this.waitIfEmpty = true;
            }
            ((GuiToggleButton)((Object)this.buttonList.get((int)0))).active = this.waitIfEmpty;
            ((GuiToggleButton)guibutton).active = this.waitTillFull;
        }
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        GuiTools.drawCenteredString(this.fontRendererObj, this.tile.getName(), 6);
    }

    public void onGuiClosed() {
        if (Game.isNotHost(this.tile.getWorld())) {
            this.tile.setWaitIfEmpty(this.waitIfEmpty);
            this.tile.setWaitTillFull(this.waitTillFull);
            PacketGuiReturn pkt = new PacketGuiReturn(this.tile);
            PacketDispatcher.sendToServer(pkt);
        }
    }

    public void updateScreen() {
        super.updateScreen();
        TileEntity t = this.tile.getWorld().getTileEntity(this.tile.getX(), this.tile.getY(), this.tile.getZ());
        if (t instanceof TileRFLoader) {
            this.tile = (TileRFLoader)t;
        } else {
            this.mc.thePlayer.closeScreen();
        }
    }
}

