/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import mods.railcraft.client.gui.TileGui;
import mods.railcraft.client.gui.buttons.GuiMultiButton;
import mods.railcraft.common.blocks.detector.TileDetector;
import mods.railcraft.common.blocks.detector.types.DetectorTank;
import mods.railcraft.common.gui.containers.ContainerDetectorTank;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.PacketGuiReturn;
import net.minecraft.entity.player.InventoryPlayer;

public class GuiDetectorTank
extends TileGui {
    private final String label;
    private final TileDetector tile;
    private final DetectorTank detector;
    private GuiMultiButton button;

    public GuiDetectorTank(InventoryPlayer inv, TileDetector tile) {
        super(tile, new ContainerDetectorTank(inv, tile), "railcraft:textures/gui/gui_detector_tank.png");
        this.tile = tile;
        this.detector = (DetectorTank)tile.getDetector();
        this.xSize = 176;
        this.ySize = 140;
        this.label = tile.getName();
    }

    public void initGui() {
        super.initGui();
        if (this.tile == null) {
            return;
        }
        this.buttonList.clear();
        int w = (this.width - this.xSize) / 2;
        int h = (this.height - this.ySize) / 2;
        this.button = new GuiMultiButton(0, w + 95, h + 22, 60, this.detector.getButtonController().copy());
        this.buttonList.add(this.button);
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        int sWidth = this.fontRendererObj.getStringWidth(this.label);
        int sPos = this.xSize / 2 - sWidth / 2;
        this.fontRendererObj.drawString(this.label, sPos, 6, 0x404040);
        this.fontRendererObj.drawString(LocalizationPlugin.translate("railcraft.gui.filter"), 50, 29, 0x404040);
    }

    public void onGuiClosed() {
        super.onGuiClosed();
        if (Game.isNotHost(this.tile.getWorld())) {
            this.detector.getButtonController().setCurrentState(this.button.getController().getCurrentState());
            PacketGuiReturn pkt = new PacketGuiReturn(this.tile);
            PacketDispatcher.sendToServer(pkt);
        }
    }
}

