/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import java.util.Iterator;
import mods.railcraft.client.gui.buttons.GuiBetterButton;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.slots.SlotRailcraft;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.gui.tooltips.ToolTipLine;
import mods.railcraft.common.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class GuiContainerRailcraft
extends GuiContainer {
    public final RailcraftContainer container;
    public final ResourceLocation texture;

    public GuiContainerRailcraft(RailcraftContainer container, String texture) {
        super((Container)container);
        this.container = container;
        this.texture = new ResourceLocation(texture);
    }

    public void drawScreen(int mouseX, int mouseY, float par3) {
        super.drawScreen(mouseX, mouseY, par3);
        int left = this.guiLeft;
        int top = this.guiTop;
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)left, (float)top, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.disableStandardItemLighting();
        InventoryPlayer playerInv = this.mc.thePlayer.inventory;
        if (playerInv.getItemStack() == null) {
            boolean mouseOver;
            int mX = mouseX - left;
            int mY = mouseY - top;
            for (Widget element : this.container.getElements()) {
                ToolTip tips;
                if (element.hidden || (tips = element.getToolTip()) == null) continue;
                boolean mouseOver2 = element.isMouseOver(mX, mY);
                tips.onTick(mouseOver2);
                if (!mouseOver2 || !tips.isReady()) continue;
                tips.refresh();
                this.drawToolTips(tips, mouseX, mouseY);
            }
            for (Widget button : this.buttonList) {
                ToolTip tips;
                if (!(button instanceof GuiBetterButton)) continue;
                GuiBetterButton betterButton = (GuiBetterButton)((Object)button);
                if (!betterButton.visible || (tips = betterButton.getToolTip()) == null) continue;
                mouseOver = betterButton.isMouseOverButton(mouseX, mouseY);
                tips.onTick(mouseOver);
                if (!mouseOver || !tips.isReady()) continue;
                tips.refresh();
                this.drawToolTips(tips, mouseX, mouseY);
            }
            for (Widget obj : this.inventorySlots.inventorySlots) {
                ToolTip tips;
                SlotRailcraft slot;
                if (!(obj instanceof SlotRailcraft) || (slot = (SlotRailcraft)((Object)obj)).getStack() != null || (tips = slot.getToolTip()) == null) continue;
                mouseOver = this.isMouseOverSlot(slot, mouseX, mouseY);
                tips.onTick(mouseOver);
                if (!mouseOver || !tips.isReady()) continue;
                tips.refresh();
                this.drawToolTips(tips, mouseX, mouseY);
            }
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    protected void drawGuiContainerBackgroundLayer(float f, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.texture);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
        int mX = mouseX - this.guiLeft;
        int mY = mouseY - this.guiTop;
        for (Widget element : this.container.getElements()) {
            if (element.hidden) continue;
            element.draw(this, x, y, mX, mY);
        }
    }

    public void drawGradientRect(int x1, int y1, int x2, int y2, int c1, int c2) {
        super.drawGradientRect(x1, y1, x2, y2, c1, c2);
    }

    private Slot getSlotAtPosition(int par1, int par2) {
        for (int var3 = 0; var3 < this.inventorySlots.inventorySlots.size(); ++var3) {
            Slot var4 = (Slot)this.inventorySlots.inventorySlots.get(var3);
            if (!this.isMouseOverSlot(var4, par1, par2)) continue;
            return var4;
        }
        return null;
    }

    private boolean isMouseOverSlot(Slot par1Slot, int par2, int par3) {
        int var4 = this.guiLeft;
        int var5 = this.guiTop;
        return (par2 -= var4) >= par1Slot.xDisplayPosition - 1 && par2 < par1Slot.xDisplayPosition + 16 + 1 && (par3 -= var5) >= par1Slot.yDisplayPosition - 1 && par3 < par1Slot.yDisplayPosition + 16 + 1;
    }

    protected void mouseClicked(int mouseX, int mouseY, int button) {
        int mX = mouseX - this.guiLeft;
        int mY = mouseY - this.guiTop;
        for (Widget element : this.container.getElements()) {
            if (element.hidden || !element.isMouseOver(mX, mY) || !element.mouseClicked(mX, mY, button)) continue;
            return;
        }
        super.mouseClicked(mouseX, mouseY, button);
    }

    protected void mouseClickMove(int x, int y, int mouseButton, long time) {
        Slot slot = this.getSlotAtPosition(x, y);
        if (mouseButton == 1 && slot instanceof SlotRailcraft && ((SlotRailcraft)slot).isPhantom()) {
            return;
        }
        super.mouseClickMove(x, y, mouseButton, time);
    }

    private void drawToolTips(ToolTip toolTips, int mouseX, int mouseY) {
        if (toolTips.size() > 0) {
            int y;
            int left = this.guiLeft;
            int top = this.guiTop;
            int lenght = 0;
            Iterator iterator = toolTips.iterator();
            while (iterator.hasNext()) {
                ToolTipLine tip = (ToolTipLine)iterator.next();
                y = this.fontRendererObj.getStringWidth(tip.text);
                if (y <= lenght) continue;
                lenght = y;
            }
            int x = mouseX - left + 12;
            y = mouseY - top - 12;
            int var14 = 8;
            if (toolTips.size() > 1) {
                var14 += 2 + (toolTips.size() - 1) * 10;
            }
            this.zLevel = 300.0f;
            GuiContainerRailcraft.itemRender.zLevel = 300.0f;
            int var15 = -267386864;
            this.drawGradientRect(x - 3, y - 4, x + lenght + 3, y - 3, var15, var15);
            this.drawGradientRect(x - 3, y + var14 + 3, x + lenght + 3, y + var14 + 4, var15, var15);
            this.drawGradientRect(x - 3, y - 3, x + lenght + 3, y + var14 + 3, var15, var15);
            this.drawGradientRect(x - 4, y - 3, x - 3, y + var14 + 3, var15, var15);
            this.drawGradientRect(x + lenght + 3, y - 3, x + lenght + 4, y + var14 + 3, var15, var15);
            int var16 = 0x505000FF;
            int var17 = (var16 & 0xFEFEFE) >> 1 | var16 & 0xFF000000;
            this.drawGradientRect(x - 3, y - 3 + 1, x - 3 + 1, y + var14 + 3 - 1, var16, var17);
            this.drawGradientRect(x + lenght + 2, y - 3 + 1, x + lenght + 3, y + var14 + 3 - 1, var16, var17);
            this.drawGradientRect(x - 3, y - 3, x + lenght + 3, y - 3 + 1, var16, var16);
            this.drawGradientRect(x - 3, y + var14 + 2, x + lenght + 3, y + var14 + 3, var17, var17);
            Iterator iterator2 = toolTips.iterator();
            while (iterator2.hasNext()) {
                ToolTipLine tip = (ToolTipLine)iterator2.next();
                String line = tip.text;
                line = line.replace('\u00a0', ' ');
                line = tip.format == null ? "\u00a77" + line : tip.format.toString() + line;
                this.fontRendererObj.drawStringWithShadow(line, x, y, -1);
                y += 10 + tip.getSpacing();
            }
            this.zLevel = 0.0f;
            GuiContainerRailcraft.itemRender.zLevel = 0.0f;
        }
    }

    public void bindTexture(ResourceLocation texture) {
        Minecraft.getMinecraft().renderEngine.bindTexture(texture);
    }

    public void drawTexture(int x, int y, int w, int h, float uMin, float vMin, float uMax, float vMax) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((double)(x + 0), (double)(y + h), (double)this.zLevel, (double)uMin, (double)vMax);
        tessellator.addVertexWithUV((double)(x + w), (double)(y + h), (double)this.zLevel, (double)uMax, (double)vMax);
        tessellator.addVertexWithUV((double)(x + w), (double)(y + 0), (double)this.zLevel, (double)uMax, (double)vMin);
        tessellator.addVertexWithUV((double)(x + 0), (double)(y + 0), (double)this.zLevel, (double)uMin, (double)vMin);
        tessellator.draw();
    }
}

