/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import mods.railcraft.client.gui.EntityGui;
import mods.railcraft.common.carts.IIC2EnergyCart;
import mods.railcraft.common.gui.containers.ContainerCartEnergy;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;

public class GuiCartEnergy
extends EntityGui {
    private final IIC2EnergyCart device;

    public GuiCartEnergy(InventoryPlayer inv, IIC2EnergyCart cart) {
        super((Entity)cart.getEntity(), new ContainerCartEnergy(inv, cart), "railcraft:textures/gui/gui_energy.png");
        this.device = cart;
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        String entityName = this.device.getName();
        int sWidth = this.fontRendererObj.getStringWidth(entityName);
        int sPos = this.xSize / 2 - sWidth / 2;
        this.fontRendererObj.drawString(entityName, sPos, 6, 0x404040);
        this.fontRendererObj.drawString("Power Level:", 80, 25, 0x404040);
        this.fontRendererObj.drawString(Integer.toString((int)this.device.getEnergy()), 115, 35, 0x404040);
        String capacity = "/" + this.device.getCapacity();
        this.fontRendererObj.drawString(capacity, 115, 45, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        super.drawGuiContainerBackgroundLayer(f, i, j);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        if (this.device.getEnergy() > 0.0) {
            int energy = this.device.getEnergyBarScaled(24);
            this.drawTexturedModalRect(x + 79, y + 34, 176, 14, energy, 17);
        }
    }
}

