/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import mods.railcraft.client.gui.EntityGui;
import mods.railcraft.common.carts.EntityCartAnchor;
import mods.railcraft.common.gui.containers.ContainerAnchor;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.StatCollector;

public class GuiCartAnchor
extends EntityGui {
    private final EntityCartAnchor cartAnchor;
    private final ContainerAnchor container;

    public GuiCartAnchor(InventoryPlayer playerInv, EntityCartAnchor anchor) {
        super((Entity)anchor, new ContainerAnchor(playerInv, anchor), "railcraft:textures/gui/gui_single_slot.png");
        this.xSize = 176;
        this.ySize = 140;
        this.cartAnchor = anchor;
        this.container = (ContainerAnchor)this.inventorySlots;
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        String label = this.cartAnchor.getCommandSenderName();
        int sWidth = this.fontRendererObj.getStringWidth(label);
        int sPos = this.xSize / 2 - sWidth / 2;
        this.fontRendererObj.drawString(label, sPos, 6, 0x404040);
        this.fontRendererObj.drawString(LocalizationPlugin.translate("railcraft.gui.anchor.fuel"), 85, 24, 0x404040);
        this.fontRendererObj.drawString(LocalizationPlugin.translate("railcraft.gui.anchor.fuel.remaining", (double)this.container.minutesRemaining / 60.0), 85, 35, 0x404040);
        this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"container.inventory"), 8, this.ySize - 96 + 2, 0x404040);
    }
}

