/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import mods.railcraft.client.gui.GuiTools;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class GuiBasic
extends GuiScreen {
    protected final int xSize;
    protected final int ySize;
    protected final String label;
    protected final ResourceLocation texture;

    protected GuiBasic(String label) {
        this.label = label;
        this.xSize = 176;
        this.ySize = 88;
        this.texture = new ResourceLocation("railcraft:textures/gui/gui_basic.png");
    }

    protected GuiBasic(String label, String texture, int x, int y) {
        this(label, new ResourceLocation(texture), x, y);
    }

    protected GuiBasic(String label, ResourceLocation texture, int x, int y) {
        this.label = label;
        this.xSize = x;
        this.ySize = y;
        this.texture = texture;
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    public void drawScreen(int x, int y, float f) {
        this.drawDefaultBackground();
        int w = (this.width - this.xSize) / 2;
        int h = (this.height - this.ySize) / 2;
        this.mc.renderEngine.bindTexture(this.texture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(w, h, 0, 0, this.xSize, this.ySize);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)w, (float)h, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GuiTools.drawCenteredString(this.fontRendererObj, this.label, 6, this.xSize);
        this.drawExtras(x, y, f);
        GL11.glPopMatrix();
        super.drawScreen(x, y, f);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
    }

    protected void drawExtras(int x, int y, float f) {
    }

    protected void keyTyped(char c, int i) {
        if (i == 1 || i == this.mc.gameSettings.keyBindInventory.getKeyCode()) {
            this.mc.thePlayer.closeScreen();
        }
    }

    public void updateScreen() {
        super.updateScreen();
        if (!this.mc.thePlayer.isEntityAlive() || this.mc.thePlayer.isDead) {
            this.mc.thePlayer.closeScreen();
        }
    }
}

