/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.core;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import mods.railcraft.common.items.ItemGoggles;
import mods.railcraft.common.plugins.forge.ChatPlugin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;

public class AuraKeyHandler {
    public static final AuraKeyHandler INSTANCE = new AuraKeyHandler();
    private static EnumSet<ItemGoggles.GoggleAura> activeAuras = EnumSet.noneOf(ItemGoggles.GoggleAura.class);
    private static EnumMap<ItemGoggles.GoggleAura, KeyBinding> keyBindings;

    private AuraKeyHandler() {
        keyBindings = new EnumMap(ItemGoggles.GoggleAura.class);
        keyBindings.put(ItemGoggles.GoggleAura.ANCHOR, new KeyBinding("railcraft.keybind.aura.anchor", 67, "Railcraft"));
        keyBindings.put(ItemGoggles.GoggleAura.TUNING, new KeyBinding("railcraft.keybind.aura.tuning", 25, "Railcraft"));
        keyBindings.put(ItemGoggles.GoggleAura.SURVEYING, new KeyBinding("railcraft.keybind.aura.surveying", 24, "Railcraft"));
        keyBindings.put(ItemGoggles.GoggleAura.SIGNALLING, new KeyBinding("railcraft.keybind.aura.signalling", 23, "Railcraft"));
        for (KeyBinding binding : keyBindings.values()) {
            ClientRegistry.registerKeyBinding((KeyBinding)binding);
        }
    }

    public static boolean isAuraEnabled(ItemGoggles.GoggleAura aura) {
        return activeAuras.contains((Object)aura);
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (Minecraft.getMinecraft().currentScreen instanceof GuiChat) {
            return;
        }
        EntityClientPlayerMP player = Minecraft.getMinecraft().thePlayer;
        for (Map.Entry<ItemGoggles.GoggleAura, KeyBinding> keyBinding : keyBindings.entrySet()) {
            if (!keyBinding.getValue().isPressed()) continue;
            ItemGoggles.GoggleAura aura = keyBinding.getKey();
            if (AuraKeyHandler.isAuraEnabled(aura)) {
                activeAuras.remove((Object)aura);
                ChatPlugin.sendLocalizedChat((EntityPlayer)player, "railcraft.gui.aura.disable", "\u00a75" + (Object)((Object)aura) + "\u00a77");
                continue;
            }
            activeAuras.add(aura);
            ChatPlugin.sendLocalizedChat((EntityPlayer)player, "railcraft.gui.aura.enable", "\u00a75" + (Object)((Object)aura) + "\u00a77");
        }
    }
}

