/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.signals;

import java.util.HashMap;
import java.util.Map;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SignalBlock;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class SignalBlockRelay
extends SignalBlock {
    private final Map<WorldCoordinate, SignalAspect> aspects = new HashMap<WorldCoordinate, SignalAspect>();

    public SignalBlockRelay(String locTag, TileEntity tile) {
        super(locTag, tile, 2);
    }

    @Override
    protected void updateSignalAspect() {
        this.aspects.keySet().retainAll(this.getPairs());
        for (WorldCoordinate otherCoord : this.getPairs()) {
            this.aspects.put(otherCoord, this.determineAspect(otherCoord));
        }
    }

    @Override
    public SignalAspect getSignalAspect() {
        if (this.isWaitingForRetest() || this.isBeingPaired()) {
            return SignalAspect.BLINK_YELLOW;
        }
        if (!this.isPaired()) {
            return SignalAspect.BLINK_RED;
        }
        SignalAspect aspect = SignalAspect.GREEN;
        for (WorldCoordinate otherCoord : this.getPairs()) {
            aspect = SignalAspect.mostRestrictive(aspect, this.aspects.get(otherCoord));
        }
        return aspect;
    }

    @Override
    protected SignalAspect getSignalAspectForPair(WorldCoordinate otherCoord) {
        SignalAspect aspect = SignalAspect.GREEN;
        for (Map.Entry<WorldCoordinate, SignalAspect> entry : this.aspects.entrySet()) {
            if (entry.getKey().equals(otherCoord)) continue;
            aspect = SignalAspect.mostRestrictive(aspect, entry.getValue());
        }
        return aspect;
    }

    @Override
    protected void saveNBT(NBTTagCompound data) {
        super.saveNBT(data);
        NBTTagList tagList = data.getTagList("aspects", 10);
        for (int i = 0; i < tagList.tagCount(); ++i) {
            NBTTagCompound nbt = tagList.getCompoundTagAt(i);
            WorldCoordinate coord = WorldCoordinate.readFromNBT(nbt, "coord");
            SignalAspect aspect = SignalAspect.readFromNBT(nbt, "aspect");
            this.aspects.put(coord, aspect);
        }
    }

    @Override
    protected void loadNBT(NBTTagCompound data) {
        super.loadNBT(data);
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<WorldCoordinate, SignalAspect> entry : this.aspects.entrySet()) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (entry.getKey() == null || entry.getValue() == null) continue;
            entry.getKey().writeToNBT(nbt, "coord");
            entry.getValue().writeToNBT(nbt, "aspect");
            tagList.appendTag((NBTBase)nbt);
        }
        data.setTag("aspects", (NBTBase)tagList);
    }
}

