/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.api;

import codechicken.nei.ItemList;
import codechicken.nei.ItemSorter;
import codechicken.nei.ItemStackSet;
import codechicken.nei.KeyManager;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.OffsetPositioner;
import codechicken.nei.SearchField;
import codechicken.nei.SubsetWidget;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.IHighlightHandler;
import codechicken.nei.api.IInfiniteItemHandler;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.INEIModeHandler;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.api.LayoutStyle;
import codechicken.nei.api.NEIInfo;
import codechicken.nei.config.Option;
import codechicken.nei.config.OptionKeyBind;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.RecipeInfo;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class API {
    public static void registerRecipeHandler(ICraftingHandler handler) {
        GuiCraftingRecipe.registerRecipeHandler(handler);
    }

    public static void registerUsageHandler(IUsageHandler handler) {
        GuiUsageRecipe.registerUsageHandler(handler);
    }

    public static void registerGuiOverlay(Class<? extends GuiContainer> classz, String ident) {
        API.registerGuiOverlay(classz, ident, 5, 11);
    }

    public static void registerGuiOverlay(Class<? extends GuiContainer> classz, String ident, int x, int y) {
        API.registerGuiOverlay(classz, ident, new OffsetPositioner(x, y));
    }

    public static void registerGuiOverlay(Class<? extends GuiContainer> classz, String ident, IStackPositioner positioner) {
        RecipeInfo.registerGuiOverlay(classz, ident, positioner);
    }

    public static void registerGuiOverlayHandler(Class<? extends GuiContainer> classz, IOverlayHandler handler, String ident) {
        RecipeInfo.registerOverlayHandler(classz, handler, ident);
    }

    public static void setGuiOffset(Class<? extends GuiContainer> classz, int x, int y) {
        RecipeInfo.setGuiOffset(classz, x, y);
    }

    public static void registerNEIGuiHandler(INEIGuiHandler handler) {
        GuiInfo.guiHandlers.add(handler);
    }

    public static void hideItem(ItemStack item) {
        ItemInfo.hiddenItems.add(item);
    }

    public static void setOverrideName(ItemStack item, String name) {
        ItemInfo.nameOverrides.put(item, name);
    }

    public static void addItemListEntry(ItemStack item) {
        ItemInfo.itemOverrides.put((Object)item.getItem(), (Object)item);
    }

    public static void setItemListEntries(Item item, Iterable<ItemStack> items) {
        if (items == null) {
            items = Collections.emptyList();
        }
        ItemInfo.itemOverrides.replaceValues((Object)item, items);
    }

    public static void addKeyBind(String ident, int defaultKey) {
        NEIClientConfig.setDefaultKeyBinding(ident, defaultKey);
        KeyManager.keyStates.put(ident, new KeyManager.KeyState());
        API.addOption(new OptionKeyBind(ident));
    }

    public static void addOption(Option option) {
        NEIClientConfig.getOptionList().addOption(option);
    }

    public static void addLayoutStyle(int styleID, LayoutStyle style) {
        LayoutManager.layoutStyles.put(styleID, style);
    }

    public static void addInfiniteItemHandler(IInfiniteItemHandler handler) {
        ItemInfo.infiniteHandlers.addFirst(handler);
    }

    public static void registerHighlightIdentifier(Block block, IHighlightHandler handler) {
        ItemInfo.highlightIdentifiers.put((Object)block, (Object)handler);
    }

    public static void addFastTransferExemptSlot(Class<? extends Slot> slotClass) {
        ItemInfo.fastTransferExemptions.add(slotClass);
    }

    public static void registerHighlightHandler(IHighlightHandler handler, ItemInfo.Layout ... layout) {
        ItemInfo.registerHighlightHandler(handler, layout);
    }

    public static void registerModeHandler(INEIModeHandler handler) {
        NEIInfo.modeHandlers.add(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addItemFilter(ItemFilter.ItemFilterProvider filterProvider) {
        List<ItemFilter.ItemFilterProvider> list = ItemList.itemFilterers;
        synchronized (list) {
            ItemList.itemFilterers.add(filterProvider);
        }
    }

    public static void addSubset(String name, ItemFilter filter) {
        API.addSubset(new SubsetWidget.SubsetTag(name, filter));
    }

    public static void addSubset(String name, Iterable<ItemStack> items) {
        ItemStackSet filter = new ItemStackSet();
        for (ItemStack item : items) {
            filter.add(item);
        }
        API.addSubset(new SubsetWidget.SubsetTag(name, filter));
    }

    public static void addSubset(SubsetWidget.SubsetTag tag) {
        SubsetWidget.addTag(tag);
    }

    public static void addSearchProvider(SearchField.ISearchProvider provider) {
        SearchField.searchProviders.add(provider);
    }

    public static void addSortOption(String name, Comparator<ItemStack> comparator) {
        ItemSorter.add(name, comparator);
    }
}

