/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIController;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.Widget;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ItemPanel
extends Widget {
    public static ArrayList<ItemStack> items = new ArrayList();
    private static ArrayList<ItemStack> _items = items;
    public ItemStack draggedStack;
    public int mouseDownSlot = -1;
    private int marginLeft;
    private int marginTop;
    private int rows;
    private int columns;
    private boolean[] validSlotMap;
    private int firstIndex;
    private int itemsPerPage;
    private int page;
    private int numPages;

    public static void updateItemList(ArrayList<ItemStack> newItems) {
        _items = newItems;
    }

    public void resize() {
        items = _items;
        this.marginLeft = this.x + this.w % 18 / 2;
        this.marginTop = this.y + this.h % 18 / 2;
        this.columns = this.w / 18;
        this.rows = this.h / 18;
        if (this.rows < 0) {
            this.rows = 0;
        }
        if (this.columns < 0) {
            this.columns = 0;
        }
        this.calculatePage();
        this.updateValidSlots();
    }

    private void calculatePage() {
        this.numPages = this.itemsPerPage == 0 ? 0 : (int)Math.ceil((float)items.size() / (float)this.itemsPerPage);
        if (this.firstIndex >= items.size()) {
            this.firstIndex = 0;
        }
        this.page = this.numPages == 0 ? 0 : this.firstIndex / this.itemsPerPage + 1;
    }

    private void updateValidSlots() {
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        this.validSlotMap = new boolean[this.rows * this.columns];
        this.itemsPerPage = 0;
        for (int i = 0; i < this.validSlotMap.length; ++i) {
            if (!this.slotValid(gui, i)) continue;
            this.validSlotMap[i] = true;
            ++this.itemsPerPage;
        }
    }

    private boolean slotValid(GuiContainer gui, int i) {
        Rectangle4i rect = this.getSlotRect(i);
        for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
            if (!handler.hideItemPanelSlot(gui, rect.x, rect.y, rect.w, rect.h)) continue;
            return false;
        }
        return true;
    }

    public Rectangle4i getSlotRect(int i) {
        return this.getSlotRect(i / this.columns, i % this.columns);
    }

    public Rectangle4i getSlotRect(int row, int column) {
        return new Rectangle4i(this.marginLeft + column * 18, this.marginTop + row * 18, 18, 18);
    }

    @Override
    public void draw(int mousex, int mousey) {
        if (this.itemsPerPage == 0) {
            return;
        }
        GuiContainerManager.enableMatrixStackLogging();
        int index = this.firstIndex;
        for (int i = 0; i < this.rows * this.columns && index < items.size(); ++i) {
            if (!this.validSlotMap[i]) continue;
            Rectangle4i rect = this.getSlotRect(i);
            if (rect.contains(mousex, mousey)) {
                GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)-296397483);
            }
            GuiContainerManager.drawItem(rect.x + 1, rect.y + 1, items.get(index));
            ++index;
        }
        GuiContainerManager.disableMatrixStackLogging();
    }

    @Override
    public void postDraw(int mousex, int mousey) {
        if (this.draggedStack != null) {
            GuiContainerManager.drawItems.zLevel += 100.0f;
            GuiContainerManager.drawItem(mousex - 8, mousey - 8, this.draggedStack);
            GuiContainerManager.drawItems.zLevel -= 100.0f;
        }
    }

    @Override
    public void mouseDragged(int mousex, int mousey, int button, long heldTime) {
        if (this.mouseDownSlot >= 0 && this.draggedStack == null && NEIClientUtils.getHeldItem() == null && NEIClientConfig.hasSMPCounterPart() && !GuiInfo.hasCustomSlots(NEIClientUtils.getGuiContainer())) {
            ItemPanelSlot mouseOverSlot = this.getSlotMouseOver(mousex, mousey);
            ItemStack stack = (ItemPanel)this.new ItemPanelSlot((int)this.mouseDownSlot).item;
            if (stack != null && (mouseOverSlot == null || mouseOverSlot.slotIndex != this.mouseDownSlot || heldTime > 500L)) {
                int amount = NEIClientConfig.getItemQuantity();
                if (amount == 0) {
                    amount = stack.getMaxStackSize();
                }
                this.draggedStack = NEIServerUtils.copyStack(stack, amount);
            }
        }
    }

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        if (this.handleDraggedClick(mousex, mousey, button)) {
            return true;
        }
        if (NEIClientUtils.getHeldItem() != null) {
            for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
                if (!handler.hideItemPanelSlot(NEIClientUtils.getGuiContainer(), mousex, mousey, 1, 1)) continue;
                return false;
            }
            if (NEIClientConfig.canPerformAction("delete") && NEIClientConfig.canPerformAction("item")) {
                if (button == 1) {
                    NEIClientUtils.decreaseSlotStack(-999);
                } else {
                    NEIClientUtils.deleteHeldItem();
                }
            } else {
                NEIClientUtils.dropHeldItem();
            }
            return true;
        }
        ItemPanelSlot hoverSlot = this.getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null) {
            if (button == 2) {
                ItemStack stack = hoverSlot.item;
                if (stack != null) {
                    int amount = NEIClientConfig.getItemQuantity();
                    if (amount == 0) {
                        amount = stack.getMaxStackSize();
                    }
                    this.draggedStack = NEIServerUtils.copyStack(stack, amount);
                }
            } else {
                this.mouseDownSlot = hoverSlot.slotIndex;
            }
            return true;
        }
        return false;
    }

    private boolean handleDraggedClick(int mousex, int mousey, int button) {
        if (this.draggedStack == null) {
            return false;
        }
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        boolean handled = false;
        for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
            if (!handler.handleDragNDrop(gui, mousex, mousey, this.draggedStack, button)) continue;
            handled = true;
            if (this.draggedStack.stackSize != 0) continue;
            this.draggedStack = null;
            return true;
        }
        if (handled) {
            return true;
        }
        Slot overSlot = gui.getSlotAtPosition(mousex, mousey);
        if (overSlot != null && overSlot.isItemValid(this.draggedStack)) {
            if (NEIClientConfig.canCheatItem(this.draggedStack)) {
                int total;
                int add;
                int contents = overSlot.getHasStack() ? overSlot.getStack().stackSize : 0;
                int n = add = button == 0 ? this.draggedStack.stackSize : 1;
                if (overSlot.getHasStack() && !NEIServerUtils.areStacksSameType(this.draggedStack, overSlot.getStack())) {
                    contents = 0;
                }
                if ((total = Math.min(contents + add, Math.min(overSlot.getSlotStackLimit(), this.draggedStack.getMaxStackSize()))) > contents) {
                    NEIClientUtils.setSlotContents(overSlot.slotNumber, NEIServerUtils.copyStack(this.draggedStack, total), true);
                    NEICPH.sendGiveItem(NEIServerUtils.copyStack(this.draggedStack, total), false, false);
                    this.draggedStack.stackSize -= total - contents;
                }
                if (this.draggedStack.stackSize == 0) {
                    this.draggedStack = null;
                }
            } else {
                this.draggedStack = null;
            }
        } else if (mousex < gui.guiLeft || mousey < gui.guiTop || mousex >= gui.guiLeft + gui.xSize || mousey >= gui.guiTop + gui.ySize) {
            this.draggedStack = null;
        }
        return true;
    }

    @Override
    public boolean handleClickExt(int mousex, int mousey, int button) {
        return this.handleDraggedClick(mousex, mousey, button);
    }

    @Override
    public void mouseUp(int mousex, int mousey, int button) {
        ItemPanelSlot hoverSlot = this.getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null && hoverSlot.slotIndex == this.mouseDownSlot && this.draggedStack == null) {
            ItemStack item = hoverSlot.item;
            if (NEIController.manager.window instanceof GuiRecipe || !NEIClientConfig.canCheatItem(item)) {
                if (button == 0) {
                    GuiCraftingRecipe.openRecipeGui("item", item);
                } else if (button == 1) {
                    GuiUsageRecipe.openRecipeGui("item", item);
                }
                this.draggedStack = null;
                this.mouseDownSlot = -1;
                return;
            }
            NEIClientUtils.cheatItem(item, button, -1);
        }
        this.mouseDownSlot = -1;
    }

    @Override
    public boolean onMouseWheel(int i, int mousex, int mousey) {
        if (!this.contains(mousex, mousey)) {
            return false;
        }
        this.scroll(-i);
        return true;
    }

    @Override
    public boolean handleKeyPress(int keyID, char keyChar) {
        if (keyID == NEIClientConfig.getKeyBinding("gui.next")) {
            this.scroll(1);
            return true;
        }
        if (keyID == NEIClientConfig.getKeyBinding("gui.prev")) {
            this.scroll(-1);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getStackMouseOver(int mousex, int mousey) {
        ItemPanelSlot slot = this.getSlotMouseOver(mousex, mousey);
        return slot == null ? null : slot.item;
    }

    public ItemPanelSlot getSlotMouseOver(int mousex, int mousey) {
        int index = this.firstIndex;
        for (int i = 0; i < this.rows * this.columns && index < items.size(); ++i) {
            if (!this.validSlotMap[i]) continue;
            if (this.getSlotRect(i).contains(mousex, mousey)) {
                return new ItemPanelSlot(index);
            }
            ++index;
        }
        return null;
    }

    public void scroll(int i) {
        if (this.itemsPerPage != 0) {
            int oldIndex = this.firstIndex;
            this.firstIndex += i * this.itemsPerPage;
            if (this.firstIndex >= items.size()) {
                this.firstIndex = 0;
            }
            if (this.firstIndex < 0) {
                this.firstIndex = oldIndex > 0 ? 0 : (items.size() - 1) / this.itemsPerPage * this.itemsPerPage;
            }
            this.calculatePage();
        }
    }

    public int getPage() {
        return this.page;
    }

    public int getNumPages() {
        return this.numPages;
    }

    @Override
    public boolean contains(int px, int py) {
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        Rectangle4i rect = new Rectangle4i(px, py, 1, 1);
        for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
            if (!handler.hideItemPanelSlot(gui, rect.x, rect.y, rect.w, rect.h)) continue;
            return false;
        }
        return super.contains(px, py);
    }

    public class ItemPanelSlot {
        public ItemStack item;
        public int slotIndex;

        public ItemPanelSlot(int index) {
            this.item = items.get(index);
            this.slotIndex = index;
        }
    }
}

