/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import minetweaker.IBracketHandler;
import minetweaker.IRecipeRemover;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.runtime.GlobalFunctions;
import stanhebben.zenscript.IZenCompileEnvironment;
import stanhebben.zenscript.IZenErrorLogger;
import stanhebben.zenscript.IZenRegistry;
import stanhebben.zenscript.TypeExpansion;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.compiler.ClassNameGenerator;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.ITypeRegistry;
import stanhebben.zenscript.compiler.TypeRegistry;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.symbols.SymbolJavaStaticField;
import stanhebben.zenscript.symbols.SymbolJavaStaticMethod;
import stanhebben.zenscript.symbols.SymbolPackage;
import stanhebben.zenscript.symbols.SymbolType;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeNative;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.ZenPosition;

public class GlobalRegistry {
    private static final Map<String, IZenSymbol> globals = new HashMap<String, IZenSymbol>();
    private static final List<IRecipeRemover> removers = new ArrayList<IRecipeRemover>();
    private static final List<IBracketHandler> bracketHandlers = new ArrayList<IBracketHandler>();
    private static final TypeRegistry types = new TypeRegistry();
    private static final SymbolPackage root = new SymbolPackage("<root>");
    private static final IZenErrorLogger errors = new MyErrorLogger();
    private static final IZenCompileEnvironment environment = new MyCompileEnvironment();
    private static final Map<String, TypeExpansion> expansions = new HashMap<String, TypeExpansion>();

    public static IZenErrorLogger getErrors() {
        return errors;
    }

    private GlobalRegistry() {
    }

    public static void registerGlobal(String name, IZenSymbol symbol) {
        if (globals.containsKey(name)) {
            throw new IllegalArgumentException("symbol already exists: " + name);
        }
        globals.put(name, symbol);
    }

    public static void registerExpansion(Class<?> cls) {
        try {
            for (Annotation annotation : cls.getAnnotations()) {
                if (!(annotation instanceof ZenExpansion)) continue;
                ZenExpansion eAnnotation = (ZenExpansion)annotation;
                if (!expansions.containsKey(eAnnotation.value())) {
                    expansions.put(eAnnotation.value(), new TypeExpansion(eAnnotation.value()));
                }
                expansions.get(eAnnotation.value()).expand(cls, (ITypeRegistry)types);
            }
        }
        catch (Throwable ex) {
            errors.error("Error while applying expansion", ex);
            ex.printStackTrace();
        }
    }

    public static void registerRemover(IRecipeRemover remover) {
        removers.add(remover);
    }

    public static void registerBracketHandler(IBracketHandler handler) {
        bracketHandlers.add(handler);
    }

    public static void registerNativeClass(Class<?> cls) {
        try {
            ZenTypeNative type = new ZenTypeNative(cls);
            type.complete((ITypeRegistry)types);
            root.put(type.getName(), (IZenSymbol)new SymbolType((ZenType)type), errors);
        }
        catch (Throwable ex) {
            MineTweakerAPI.logError("Error for " + cls, ex);
            ex.printStackTrace();
        }
    }

    public static TypeRegistry getTypeRegistry() {
        return types;
    }

    public static void remove(IIngredient ingredient) {
        for (IRecipeRemover remover : removers) {
            remover.remove(ingredient);
        }
    }

    public static IZenSymbol resolveBracket(IEnvironmentGlobal environment, List<Token> tokens) {
        for (IBracketHandler handler : bracketHandlers) {
            IZenSymbol symbol = handler.resolve(environment, tokens);
            if (symbol == null) continue;
            return symbol;
        }
        return null;
    }

    public static IZenSymbol getStaticFunction(Class cls, String name, Class ... arguments) {
        IJavaMethod method = JavaMethod.get((ITypeRegistry)types, (Class)cls, (String)name, (Class[])arguments);
        if (method == null) {
            return null;
        }
        return new SymbolJavaStaticMethod(method);
    }

    public static IZenSymbol getStaticField(Class cls, String name) {
        try {
            Field field = cls.getDeclaredField(name);
            return new SymbolJavaStaticField(cls, field, (ITypeRegistry)types);
        }
        catch (NoSuchFieldException ex) {
            Logger.getLogger(GlobalRegistry.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        catch (SecurityException ex) {
            Logger.getLogger(GlobalRegistry.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static IEnvironmentGlobal makeGlobalEnvironment(Map<String, byte[]> classes) {
        return new MyGlobalEnvironment(classes);
    }

    static {
        GlobalRegistry.registerGlobal("print", GlobalRegistry.getStaticFunction(GlobalFunctions.class, "print", String.class));
        GlobalRegistry.registerGlobal("isNull", GlobalRegistry.getStaticFunction(GlobalFunctions.class, "isNull", Object.class));
        GlobalRegistry.registerGlobal("max", GlobalRegistry.getStaticFunction(Math.class, "max", Integer.TYPE, Integer.TYPE));
        GlobalRegistry.registerGlobal("min", GlobalRegistry.getStaticFunction(Math.class, "min", Integer.TYPE, Integer.TYPE));
        GlobalRegistry.registerGlobal("pow", GlobalRegistry.getStaticFunction(Math.class, "pow", Double.TYPE, Double.TYPE));
    }

    private static class MyGlobalEnvironment
    implements IEnvironmentGlobal {
        private final Map<String, byte[]> classes;
        private final Map<String, IZenSymbol> symbols;
        private final ClassNameGenerator generator;

        public MyGlobalEnvironment(Map<String, byte[]> classes) {
            this.classes = classes;
            this.symbols = new HashMap<String, IZenSymbol>();
            this.generator = new ClassNameGenerator();
        }

        public IZenCompileEnvironment getEnvironment() {
            return environment;
        }

        public TypeExpansion getExpansion(String name) {
            return (TypeExpansion)expansions.get(name);
        }

        public String makeClassName() {
            return this.generator.generate();
        }

        public String makeClassNameWithMiddleName(String middleName) {
            return this.generator.generateWithMiddleName(middleName);
        }

        public boolean containsClass(String name) {
            return this.classes.containsKey(name);
        }

        public void putClass(String name, byte[] data) {
            this.classes.put(name, data);
        }

        public IPartialExpression getValue(String name, ZenPosition position) {
            if (this.symbols.containsKey(name)) {
                return this.symbols.get(name).instance(position);
            }
            if (globals.containsKey(name)) {
                return ((IZenSymbol)globals.get(name)).instance(position);
            }
            IZenSymbol pkg = root.get(name);
            if (pkg == null) {
                return null;
            }
            return pkg.instance(position);
        }

        public void putValue(String name, IZenSymbol value, ZenPosition position) {
            if (this.symbols.containsKey(name)) {
                this.error(position, "Value already defined in this scope: " + name);
            } else {
                this.symbols.put(name, value);
            }
        }

        public ZenType getType(Type type) {
            return types.getType(type);
        }

        public void error(ZenPosition position, String message) {
            MineTweakerAPI.logError(position.toString() + " > " + message);
        }

        public void warning(ZenPosition position, String message) {
            MineTweakerAPI.logWarning(position.toString() + " > " + message);
        }

        public void info(ZenPosition position, String message) {
            MineTweakerAPI.logInfo(position.toString() + " > " + message);
        }

        public void error(String message) {
            MineTweakerAPI.logError(message);
        }

        public void error(String message, Throwable e) {
            MineTweakerAPI.logError(message, e);
        }

        public void warning(String message) {
            MineTweakerAPI.logWarning(message);
        }

        public void info(String message) {
            MineTweakerAPI.logInfo(message);
        }

        public Set<String> getClassNames() {
            return this.classes.keySet();
        }

        public byte[] getClass(String name) {
            return this.classes.get(name);
        }
    }

    private static class MyCompileEnvironment
    implements IZenCompileEnvironment {
        private MyCompileEnvironment() {
        }

        public IZenErrorLogger getErrorLogger() {
            return errors;
        }

        public IZenSymbol getGlobal(String name) {
            if (globals.containsKey(name)) {
                return (IZenSymbol)globals.get(name);
            }
            return root.get(name);
        }

        public IZenSymbol getBracketed(IEnvironmentGlobal environment, List<Token> tokens) {
            return GlobalRegistry.resolveBracket(environment, tokens);
        }

        public TypeRegistry getTypeRegistry() {
            return types;
        }

        public TypeExpansion getExpansion(String type) {
            return (TypeExpansion)expansions.get(type);
        }

        public void setRegistry(IZenRegistry registry) {
            throw new UnsupportedOperationException("Registry is not local");
        }
    }

    private static class MyErrorLogger
    implements IZenErrorLogger {
        private MyErrorLogger() {
        }

        public void error(ZenPosition position, String message) {
            if (position == null) {
                MineTweakerAPI.logError("system: " + message);
            } else {
                MineTweakerAPI.logError(position + ": " + message);
            }
        }

        public void warning(ZenPosition position, String message) {
            if (position == null) {
                MineTweakerAPI.logWarning("system: " + message);
            } else {
                MineTweakerAPI.logWarning(position + ": " + message);
            }
        }

        public void info(ZenPosition position, String message) {
            if (position == null) {
                MineTweakerAPI.logInfo("system: " + message);
            } else {
                MineTweakerAPI.logInfo(position + ": " + message);
            }
        }

        public void error(String message) {
            this.error(null, message);
        }

        public void error(String message, Throwable e) {
            this.error(null, message);
        }

        public void warning(String message) {
            this.warning(null, message);
        }

        public void info(String message) {
            this.info(null, message);
        }
    }
}

