/*
 * Decompiled with CFR 0.152.
 */
package mantle.items.abstracts;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;

public class CraftingItem
extends Item {
    public String modTexPrefix;
    public String[] textureNames;
    public String[] unlocalizedNames;
    public String folder;
    public IIcon[] icons;

    public CraftingItem(String[] names, String[] tex, String folder, String modTexturePrefix, CreativeTabs tab) {
        this.modTexPrefix = modTexturePrefix;
        if (tab != null) {
            this.setCreativeTab(tab);
        }
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
        this.textureNames = tex;
        this.unlocalizedNames = names;
        this.folder = folder;
    }

    public void updateData(String[] names, String[] tex, String folder, String modTexturePrefix) {
        this.modTexPrefix = modTexturePrefix;
        this.textureNames = tex;
        this.unlocalizedNames = names;
        this.folder = folder;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int meta) {
        int arr = MathHelper.clamp_int((int)meta, (int)0, (int)this.unlocalizedNames.length);
        if (arr > this.icons.length) {
            return this.icons[0];
        }
        return this.icons[arr];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.icons = new IIcon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            if (this.textureNames[i].equals("")) continue;
            this.icons[i] = iconRegister.registerIcon(this.modTexPrefix + ":" + this.folder + this.textureNames[i]);
        }
    }

    public String getUnlocalizedName(ItemStack stack) {
        int arr = MathHelper.clamp_int((int)stack.getItemDamage(), (int)0, (int)this.unlocalizedNames.length);
        return this.getUnlocalizedName() + "." + this.unlocalizedNames[arr];
    }

    public void getSubItems(Item b, CreativeTabs tab, List list) {
        for (int i = 0; i < this.unlocalizedNames.length; ++i) {
            if (this.textureNames[i].equals("")) continue;
            list.add(new ItemStack(b, 1, i));
        }
    }
}

