/*
 * Decompiled with CFR 0.152.
 */
package mantle.blocks.abstracts;

import java.util.Random;
import mantle.blocks.abstracts.InventoryLogic;
import mantle.blocks.iface.IFacingLogic;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class AdaptiveInventoryLogic
extends InventoryLogic
implements IFacingLogic {
    Random random = new Random();
    protected int inventorySize;

    public AdaptiveInventoryLogic() {
        super(0);
    }

    protected void adjustInventory(int size, boolean forceAdjust) {
        if (size != this.inventorySize || forceAdjust) {
            this.inventorySize = size;
            ItemStack[] tempInv = this.inventory;
            this.inventory = new ItemStack[size];
            int invLength = tempInv.length > this.inventory.length ? this.inventory.length : tempInv.length;
            System.arraycopy(tempInv, 0, this.inventory, 0, invLength);
            if (tempInv.length > this.inventory.length) {
                for (int i = this.inventory.length; i < tempInv.length; ++i) {
                    ItemStack stack = tempInv[i];
                    if (stack == null) continue;
                    float jumpX = this.random.nextFloat() * 0.8f + 0.1f;
                    float jumpY = this.random.nextFloat() * 0.8f + 0.1f;
                    float jumpZ = this.random.nextFloat() * 0.8f + 0.1f;
                    int offsetX = 0;
                    int offsetY = 0;
                    int offsetZ = 0;
                    switch (this.getTossDirection()) {
                        case 0: {
                            --offsetY;
                            break;
                        }
                        case 1: {
                            ++offsetY;
                            break;
                        }
                        case 2: {
                            --offsetZ;
                            break;
                        }
                        case 3: {
                            ++offsetZ;
                            break;
                        }
                        case 4: {
                            --offsetX;
                            break;
                        }
                        case 5: {
                            ++offsetX;
                        }
                    }
                    while (stack.stackSize > 0) {
                        int itemSize = this.random.nextInt(21) + 10;
                        if (itemSize > stack.stackSize) {
                            itemSize = stack.stackSize;
                        }
                        stack.stackSize -= itemSize;
                        EntityItem entityitem = new EntityItem(this.worldObj, (double)((float)this.xCoord + jumpX + (float)offsetX), (double)((float)this.yCoord + jumpY), (double)((float)this.zCoord + jumpZ + (float)offsetZ), new ItemStack(stack.getItem(), itemSize, stack.getItemDamage()));
                        if (stack.hasTagCompound()) {
                            entityitem.getEntityItem().setTagCompound((NBTTagCompound)stack.getTagCompound().copy());
                        }
                        float offset = 0.05f;
                        entityitem.motionX = (float)this.random.nextGaussian() * offset;
                        entityitem.motionY = (float)this.random.nextGaussian() * offset + 0.2f;
                        entityitem.motionZ = (float)this.random.nextGaussian() * offset;
                        this.worldObj.spawnEntityInWorld((Entity)entityitem);
                    }
                }
            }
        }
    }

    public int getTossDirection() {
        return this.getRenderDirection();
    }
}

