/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual.gui;

import blusunrize.lib.manual.IManualPage;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import blusunrize.lib.manual.gui.GuiClickableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiManual
extends GuiScreen {
    int xSize = 186;
    int ySize = 198;
    int guiLeft;
    int guiTop;
    int manualTick = 0;
    List<GuiButton> pageButtons = new ArrayList<GuiButton>();
    public static String selectedCategory;
    public static String selectedEntry;
    public static ArrayList<String> previousSelectedEntry;
    public static int page;
    public static GuiManual activeManual;
    private static String categoryBeforeSearch;
    ManualInstance manual;
    String texture;
    String[] headers = new String[0];
    boolean backButtonPressed = false;
    int[] lastClick;
    int[] lastDrag;
    GuiTextField searchField;
    int hasSuggestions = -1;
    String[] suggestionHeaders = new String[0];
    int prevGuiScale = -1;

    public GuiManual(ManualInstance manual, String texture) {
        this.manual = manual;
        this.texture = texture;
        this.prevGuiScale = Minecraft.getMinecraft().gameSettings.guiScale;
        if (this.prevGuiScale != 0 && this.prevGuiScale != 2 && manual.allowGuiRescale()) {
            Minecraft.getMinecraft().gameSettings.guiScale = 2;
        }
        activeManual = this;
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    public void initGui() {
        if (Minecraft.getMinecraft().gameSettings.guiScale == 1) {
            Minecraft.getMinecraft().gameSettings.guiScale = 2;
            ScaledResolution res = new ScaledResolution(this.mc, this.mc.displayWidth, this.mc.displayHeight);
            this.width = res.getScaledWidth();
            this.height = res.getScaledHeight();
            Minecraft.getMinecraft().gameSettings.guiScale = 1;
        }
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        boolean textField = false;
        this.buttonList.clear();
        this.pageButtons.clear();
        this.headers = new String[0];
        this.suggestionHeaders = new String[0];
        this.hasSuggestions = -1;
        if (this.manual.getEntry(selectedEntry) != null) {
            IManualPage mPage;
            ManualInstance.ManualEntry entry = this.manual.getEntry(selectedEntry);
            IManualPage iManualPage = mPage = page < 0 || page >= entry.getPages().length ? null : entry.getPages()[page];
            if (mPage != null) {
                mPage.initPage(this, this.guiLeft + 32, this.guiTop + 28, this.pageButtons);
            }
            this.buttonList.addAll(this.pageButtons);
        } else if (this.manual.getSortedCategoryList() == null || this.manual.getSortedCategoryList().length <= 1) {
            ArrayList<String> lHeaders = new ArrayList<String>();
            for (ManualInstance.ManualEntry e : this.manual.manualContents.values()) {
                if (!this.manual.showEntryInList(e)) continue;
                lHeaders.add(e.getName());
            }
            this.headers = lHeaders.toArray(new String[lHeaders.size()]);
            this.buttonList.add(new GuiClickableList(this, 0, this.guiLeft + 40, this.guiTop + 20, 100, 148, 1.0f, 1, this.headers));
            textField = true;
        } else if (this.manual.manualContents.containsKey((Object)selectedCategory)) {
            ArrayList<String> lHeaders = new ArrayList<String>();
            for (ManualInstance.ManualEntry e : this.manual.manualContents.get((Object)selectedCategory)) {
                if (!this.manual.showEntryInList(e)) continue;
                lHeaders.add(e.getName());
            }
            this.headers = lHeaders.toArray(new String[lHeaders.size()]);
            this.buttonList.add(new GuiClickableList(this, 0, this.guiLeft + 40, this.guiTop + 20, 100, 148, 1.0f, 1, this.headers));
            textField = true;
        } else {
            ArrayList<String> lHeaders = new ArrayList<String>();
            for (String cat : this.manual.getSortedCategoryList()) {
                if (!this.manual.showCategoryInList(cat)) continue;
                lHeaders.add(cat);
            }
            this.headers = lHeaders.toArray(new String[lHeaders.size()]);
            this.buttonList.add(new GuiClickableList(this, 0, this.guiLeft + 40, this.guiTop + 20, 100, 148, 1.0f, 0, this.headers));
            textField = true;
        }
        if (this.manual.manualContents.containsKey((Object)selectedCategory) || this.manual.getEntry(selectedEntry) != null) {
            this.buttonList.add(new GuiButtonManualNavigation(this, 1, this.guiLeft + 24, this.guiTop + 10, 10, 10, 0));
        }
        if (textField) {
            Keyboard.enableRepeatEvents((boolean)true);
            this.searchField = new GuiTextField(this.fontRendererObj, this.guiLeft + 166, this.guiTop + 78, 120, 12);
            this.searchField.setTextColor(-1);
            this.searchField.setDisabledTextColour(-1);
            this.searchField.setEnableBackgroundDrawing(false);
            this.searchField.setMaxStringLength(17);
            this.searchField.setFocused(true);
            this.searchField.setCanLoseFocus(false);
        } else if (this.searchField != null) {
            this.searchField = null;
        }
    }

    public void drawScreen(int mx, int my, float f) {
        ++this.manualTick;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean uni = this.manual.fontRenderer.getUnicodeFlag();
        this.manual.fontRenderer.setUnicodeFlag(true);
        ManualUtils.bindTexture(this.texture);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        if (this.searchField != null) {
            int l;
            int n = l = this.searchField.getText() != null ? this.searchField.getText().length() * 6 : 0;
            if (l > 20) {
                this.drawTexturedModalRect(this.guiLeft + 166, this.guiTop + 74, 136 + (120 - l), 238, l, 18);
            }
            if (this.hasSuggestions != -1 && this.hasSuggestions < this.buttonList.size()) {
                this.drawTexturedModalRect(this.guiLeft + 174, this.guiTop + 100, 214, 212, 16, 26);
                int h = ((GuiClickableList)((Object)this.buttonList.get(this.hasSuggestions))).getFontHeight() * Math.min(((GuiClickableList)((Object)this.buttonList.get((int)this.hasSuggestions))).perPage, ((GuiClickableList)((Object)this.buttonList.get((int)this.hasSuggestions))).entries.length);
                int w = 76;
                this.drawTexturedModalRect(this.guiLeft + 174, this.guiTop + 116, 230, 212, 16, 16);
                this.drawTexturedModalRect(this.guiLeft + 174, this.guiTop + 132 + h, 230, 228, 16, 10);
                this.drawTexturedModalRect(this.guiLeft + 190 + w, this.guiTop + 116, 246, 212, 10, 16);
                this.drawTexturedModalRect(this.guiLeft + 190 + w, this.guiTop + 132 + h, 246, 228, 10, 10);
                for (int hh = 0; hh < h; ++hh) {
                    this.drawTexturedModalRect(this.guiLeft + 174, this.guiTop + 132 + hh, 230, 228, 16, 1);
                    for (int ww = 0; ww < w; ++ww) {
                        this.drawTexturedModalRect(this.guiLeft + 190 + ww, this.guiTop + 132 + hh, 246, 228, 1, 1);
                    }
                    this.drawTexturedModalRect(this.guiLeft + 190 + w, this.guiTop + 132 + hh, 246, 228, 10, 1);
                }
                for (int ww = 0; ww < w; ++ww) {
                    this.drawTexturedModalRect(this.guiLeft + 190 + ww, this.guiTop + 116, 246, 212, 1, 16);
                    this.drawTexturedModalRect(this.guiLeft + 190 + ww, this.guiTop + 132 + h, 246, 228, 1, 10);
                }
            }
        }
        if (this.manual.getEntry(selectedEntry) != null) {
            IManualPage mPage;
            ManualInstance.ManualEntry entry = this.manual.getEntry(selectedEntry);
            boolean b0 = (mx -= this.guiLeft) > 32 && mx < 49 && (my -= this.guiTop) > 179 && my < 189;
            boolean b1 = mx > 135 && mx < 152 && my > 179 && my < 189;
            GL11.glEnable((int)3042);
            if (page > 0) {
                this.drawTexturedModalRect(this.guiLeft + 32, this.guiTop + 179, 0, 216 + (b0 ? 20 : 0), 16, 10);
            }
            if (page < entry.getPages().length - 1) {
                this.drawTexturedModalRect(this.guiLeft + 136, this.guiTop + 179, 0, 226 + (b1 ? 20 : 0), 16, 10);
            }
            this.drawCenteredStringScaled(this.manual.fontRenderer, EnumChatFormatting.BOLD + this.manual.formatEntryName(entry.getName()), this.guiLeft + this.xSize / 2, this.guiTop + 14, this.manual.getTitleColour(), 1.0f, true);
            this.drawCenteredStringScaled(this.manual.fontRenderer, this.manual.formatEntrySubtext(entry.getName()), this.guiLeft + this.xSize / 2, this.guiTop + 22, this.manual.getSubTitleColour(), 1.0f, true);
            this.drawCenteredStringScaled(this.manual.fontRenderer, EnumChatFormatting.BOLD.toString() + (page + 1), this.guiLeft + this.xSize / 2, this.guiTop + 183, this.manual.getPagenumberColour(), 1.0f, false);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            IManualPage iManualPage = mPage = page < 0 || page >= entry.getPages().length ? null : entry.getPages()[page];
            if (mPage != null) {
                mPage.renderPage(this, this.guiLeft + 32, this.guiTop + 28, mx + this.guiLeft, my + this.guiTop);
            }
            mx += this.guiLeft;
            my += this.guiTop;
        } else {
            String title = this.manual.manualContents.containsKey((Object)selectedCategory) ? this.manual.formatCategoryName(selectedCategory) : this.manual.getManualName();
            this.drawCenteredStringScaled(this.manual.fontRenderer, EnumChatFormatting.BOLD + title, this.guiLeft + this.xSize / 2, this.guiTop + 12, this.manual.getTitleColour(), 1.0f, true);
        }
        if (this.searchField != null) {
            this.manual.fontRenderer.setUnicodeFlag(true);
            this.searchField.drawTextBox();
            if (this.hasSuggestions != -1 && this.hasSuggestions < this.buttonList.size()) {
                this.manual.fontRenderer.drawString("It looks like you meant:", this.guiLeft + 180, this.guiTop + 128, this.manual.getTextColour(), false);
            }
        }
        this.manual.fontRenderer.setUnicodeFlag(uni);
        super.drawScreen(mx, my, f);
    }

    public void onGuiClosed() {
        super.onGuiClosed();
        if (this.prevGuiScale != -1 && this.manual.allowGuiRescale()) {
            Minecraft.getMinecraft().gameSettings.guiScale = this.prevGuiScale;
        }
    }

    public void actionPerformed(GuiButton button) {
        if (button.id == 0) {
            int sel = ((GuiClickableList)button).selectedOption;
            if (sel >= 0 && sel < this.headers.length) {
                if (((GuiClickableList)button).translationType == 0) {
                    selectedCategory = this.headers[sel];
                } else {
                    previousSelectedEntry.clear();
                    selectedEntry = this.headers[sel];
                }
            }
            ((GuiClickableList)button).selectedOption = -1;
            this.initGui();
        } else if (button.id == 11) {
            int sel = ((GuiClickableList)button).selectedOption;
            if (sel >= 0 && sel < this.suggestionHeaders.length) {
                selectedEntry = this.suggestionHeaders[sel];
            }
            ((GuiClickableList)button).selectedOption = -1;
            this.initGui();
        } else if (button.id == 1 && !this.backButtonPressed) {
            if (selectedEntry != null) {
                if (previousSelectedEntry.size() > 0) {
                    selectedEntry = previousSelectedEntry.get(0);
                    previousSelectedEntry.remove(0);
                } else {
                    selectedEntry = null;
                }
            } else if (selectedCategory != null) {
                selectedCategory = null;
            }
            page = 0;
            this.backButtonPressed = true;
            this.initGui();
        } else if (this.pageButtons.contains(button) && this.manual.getEntry(selectedEntry) != null) {
            IManualPage mPage;
            ManualInstance.ManualEntry entry = this.manual.getEntry(selectedEntry);
            IManualPage iManualPage = mPage = page < 0 || page >= entry.getPages().length ? null : entry.getPages()[page];
            if (mPage != null) {
                mPage.buttonPressed(this, button);
            }
        }
    }

    public void drawCenteredStringScaled(FontRenderer fr, String s, int x, int y, int colour, float scale, boolean shadow) {
        int xx = (int)Math.floor((float)x / scale - (float)(fr.getStringWidth(s) / 2));
        int yy = (int)Math.floor((float)y / scale - (float)(fr.FONT_HEIGHT / 2));
        if (scale != 1.0f) {
            GL11.glScalef((float)scale, (float)scale, (float)scale);
        }
        fr.drawString(s, xx, yy, colour, shadow);
        if (scale != 1.0f) {
            GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
        }
    }

    public void drawGradientRect(int x1, int y1, int x2, int y2, int colour1, int colour2) {
        super.drawGradientRect(x1, y1, x2, y2, colour1, colour2);
        GL11.glEnable((int)3042);
    }

    public void renderToolTip(ItemStack stack, int x, int y) {
        super.renderToolTip(stack, x, y);
    }

    public void drawHoveringText(List text, int x, int y, FontRenderer font) {
        super.drawHoveringText(text, x, y, font);
    }

    public void handleMouseInput() {
        super.handleMouseInput();
        int wheel = Mouse.getEventDWheel();
        if (wheel != 0 && this.manual.getEntry(selectedEntry) != null) {
            ManualInstance.ManualEntry entry = this.manual.getEntry(selectedEntry);
            if (wheel > 0 && page > 0) {
                --page;
                this.initGui();
            } else if (wheel < 0 && page < entry.getPages().length - 1) {
                ++page;
                this.initGui();
            }
        }
    }

    public void mouseClicked(int mx, int my, int button) {
        super.mouseClicked(mx, my, button);
        if (button == 0 && this.manual.getEntry(selectedEntry) != null) {
            ManualInstance.ManualEntry entry = this.manual.getEntry(selectedEntry);
            if (page > 0 && (mx -= this.guiLeft) > 32 && mx < 49 && (my -= this.guiTop) > 179 && my < 189) {
                --page;
                this.initGui();
            }
            if (page < entry.getPages().length - 1 && mx > 135 && mx < 152 && my > 179 && my < 189) {
                ++page;
                this.initGui();
            }
        } else if (button == 1) {
            if (this.searchField != null && this.searchField.getText() != null && !this.searchField.getText().isEmpty()) {
                this.searchField.setText("");
            } else if (selectedEntry != null) {
                if (previousSelectedEntry.size() > 0) {
                    selectedEntry = previousSelectedEntry.get(0);
                    previousSelectedEntry.remove(0);
                } else {
                    selectedEntry = null;
                }
            } else if (selectedCategory != null) {
                selectedCategory = null;
            }
            page = 0;
            this.initGui();
        }
        this.lastClick = new int[]{mx, my};
        if (this.searchField != null) {
            this.searchField.mouseClicked(mx, my, button);
        }
    }

    protected void mouseMovedOrUp(int mx, int my, int action) {
        super.mouseMovedOrUp(mx, my, action);
        if (this.backButtonPressed && (action == 0 || action == 1)) {
            this.backButtonPressed = false;
        }
        this.lastClick = null;
        this.lastDrag = null;
    }

    protected void mouseClickMove(int mx, int my, int button, long time) {
        if (this.lastClick != null && this.manual.getEntry(selectedEntry) != null && page < this.manual.getEntry(selectedEntry).getPages().length) {
            ManualInstance.ManualEntry entry = this.manual.getEntry(selectedEntry);
            if (this.lastDrag == null) {
                this.lastDrag = new int[]{mx - this.guiLeft, my - this.guiTop};
            }
            entry.getPages()[page].mouseDragged(this.guiLeft + 32, this.guiTop + 28, this.lastClick[0], this.lastClick[1], mx - this.guiLeft, my - this.guiTop, this.lastDrag[0], this.lastDrag[1], button);
            this.lastDrag = new int[]{mx - this.guiLeft, my - this.guiTop};
        }
    }

    protected void keyTyped(char c, int i) {
        if (this.searchField != null && this.searchField.textboxKeyTyped(c, i)) {
            String search = this.searchField.getText();
            if (search == null || search.trim().isEmpty()) {
                if (categoryBeforeSearch != null) {
                    selectedCategory = categoryBeforeSearch;
                    categoryBeforeSearch = null;
                }
                this.hasSuggestions = -1;
                this.initGui();
            } else {
                if (categoryBeforeSearch == null) {
                    categoryBeforeSearch = selectedCategory;
                }
                selectedCategory = "SomeStringThatIsntACategory";
                search = search.toLowerCase();
                ArrayList<String> lHeaders = new ArrayList<String>();
                HashMap<String, String> lSpellcheck = new HashMap<String, String>();
                for (Object e : this.manual.manualContents.values()) {
                    if (!this.manual.showEntryInList((ManualInstance.ManualEntry)e)) continue;
                    if (this.manual.formatEntryName(((ManualInstance.ManualEntry)e).getName()).toLowerCase().contains(search)) {
                        lHeaders.add(((ManualInstance.ManualEntry)e).getName());
                        continue;
                    }
                    lSpellcheck.put(this.manual.formatEntryName(((ManualInstance.ManualEntry)e).getName()), ((ManualInstance.ManualEntry)e).getName());
                }
                ArrayList<String> lCorrections = ManualUtils.getPrimitiveSpellingCorrections(search, lSpellcheck.keySet().toArray(new String[lSpellcheck.keySet().size()]), 4);
                block1: for (String key : lSpellcheck.keySet()) {
                    if (lCorrections.contains(key)) continue;
                    ManualInstance.ManualEntry e = this.manual.getEntry((String)lSpellcheck.get(key));
                    for (IManualPage page : e.getPages()) {
                        if (!page.listForSearch(search)) continue;
                        lHeaders.add(e.getName());
                        continue block1;
                    }
                }
                this.headers = lHeaders.toArray(new String[lHeaders.size()]);
                this.buttonList.set(0, new GuiClickableList(this, 0, this.guiLeft + 40, this.guiTop + 20, 100, 148, 1.0f, 1, this.headers));
                if (!lCorrections.isEmpty()) {
                    GuiClickableList suggestions = new GuiClickableList(this, 11, this.guiLeft + 180, this.guiTop + 138, 100, 80, 1.0f, -1, lCorrections.toArray(new String[0]));
                    if (this.hasSuggestions != -1) {
                        this.buttonList.set(this.hasSuggestions, suggestions);
                    } else {
                        this.hasSuggestions = this.buttonList.size();
                        this.buttonList.add(suggestions);
                    }
                    this.suggestionHeaders = new String[lCorrections.size()];
                    for (int j = 0; j < this.suggestionHeaders.length; ++j) {
                        this.suggestionHeaders[j] = (String)lSpellcheck.get(lCorrections.get(j));
                    }
                } else if (this.hasSuggestions != -1) {
                    this.buttonList.remove(this.hasSuggestions);
                    this.hasSuggestions = -1;
                }
            }
        } else {
            super.keyTyped(c, i);
        }
    }

    static {
        previousSelectedEntry = new ArrayList();
        categoryBeforeSearch = null;
    }
}

