/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual.gui;

import blusunrize.lib.manual.gui.GuiManual;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiClickableList
extends GuiButton {
    String[] entries;
    float textScale;
    int offset;
    int maxOffset;
    int perPage;
    int translationType;
    GuiManual gui;
    private long prevWheelNano = 0L;
    public int selectedOption = -1;

    public GuiClickableList(GuiManual gui, int id, int x, int y, int w, int h, float textScale, int translationType, String ... entries) {
        super(id, x, y, w, h, "");
        this.gui = gui;
        this.textScale = textScale;
        this.entries = entries;
        this.translationType = translationType;
        this.perPage = (h - 8) / this.getFontHeight();
        if (this.perPage < entries.length) {
            this.maxOffset = entries.length - this.perPage;
        }
    }

    int getFontHeight() {
        return (int)((float)this.gui.manual.fontRenderer.FONT_HEIGHT * this.textScale);
    }

    public void drawButton(Minecraft mc, int mx, int my) {
        FontRenderer fr = this.gui.manual.fontRenderer;
        boolean uni = fr.getUnicodeFlag();
        fr.setUnicodeFlag(true);
        int mmY = my - this.yPosition;
        GL11.glPushMatrix();
        GL11.glScalef((float)this.textScale, (float)this.textScale, (float)this.textScale);
        GL11.glTranslatef((float)((float)this.xPosition / this.textScale), (float)((float)this.yPosition / this.textScale), (float)0.0f);
        for (int i = 0; i < Math.min(this.perPage, this.entries.length); ++i) {
            int j;
            int col = this.gui.manual.getTextColour();
            if (mmY >= i * this.getFontHeight() && mmY < (i + 1) * this.getFontHeight()) {
                col = this.gui.manual.getHighlightColour();
            }
            if (i != 0) {
                GL11.glTranslatef((float)0.0f, (float)this.getFontHeight(), (float)0.0f);
            }
            if ((j = this.offset + i) > this.entries.length - 1) {
                j = this.entries.length - 1;
            }
            String s = this.translationType == -1 ? this.entries[j] : (this.translationType == 0 ? this.gui.manual.formatCategoryName(this.entries[j]) : this.gui.manual.formatEntryName(this.entries[j]));
            fr.drawString(s, 0, 0, col, false);
        }
        GL11.glScalef((float)(1.0f / this.textScale), (float)(1.0f / this.textScale), (float)(1.0f / this.textScale));
        GL11.glPopMatrix();
        fr.setUnicodeFlag(uni);
        int mouseWheel = Mouse.getEventDWheel();
        if (mouseWheel != 0 && this.maxOffset > 0 && Mouse.getEventNanoseconds() != this.prevWheelNano) {
            this.prevWheelNano = Mouse.getEventNanoseconds();
            if (mouseWheel < 0 && this.offset < this.maxOffset) {
                ++this.offset;
            }
            if (mouseWheel > 0 && this.offset > 0) {
                --this.offset;
            }
        }
    }

    public boolean mousePressed(Minecraft mc, int mx, int my) {
        boolean b = super.mousePressed(mc, mx, my);
        this.selectedOption = -1;
        if (b) {
            int mmY = my - this.yPosition;
            for (int i = this.offset; i < Math.min(this.perPage, this.entries.length); ++i) {
                if (mmY < i * this.getFontHeight() || mmY >= (i + 1) * this.getFontHeight()) continue;
                this.selectedOption = i;
            }
        }
        return this.selectedOption != -1;
    }
}

