/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.world;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityLantern;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWoodenCrate;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.common.ChestGenHooks;

public class VillageEngineersHouse
extends StructureVillagePieces.Village {
    public static ChestGenHooks crateContents;
    public static final String crate = "ieVillageCrates";
    static List<ChunkCoordinates> framesHung;
    private int groundLevel = -1;

    public VillageEngineersHouse() {
    }

    public VillageEngineersHouse(StructureVillagePieces.Start villagePiece, int par2, Random par3Random, StructureBoundingBox par4StructureBoundingBox, int par5) {
        super(villagePiece, par2);
        this.coordBaseMode = par5;
        this.boundingBox = par4StructureBoundingBox;
    }

    public boolean addComponentParts(World world, Random rand, StructureBoundingBox box) {
        if (this.groundLevel < 0) {
            this.groundLevel = this.getAverageGroundLevel(world, box);
            if (this.groundLevel < 0) {
                return true;
            }
            this.boundingBox.offset(0, this.groundLevel - this.boundingBox.maxY + 10 - 1, 0);
        }
        this.fillWithBlocks(world, box, 0, 0, 0, 10, 9, 8, Blocks.air, Blocks.air, false);
        this.fillWithBlocks(world, box, 1, 0, 1, 9, 0, 8, Blocks.cobblestone, Blocks.cobblestone, false);
        this.fillWithBlocks(world, box, 6, 0, 1, 9, 0, 2, Blocks.air, Blocks.air, false);
        int stairMeta = this.coordBaseMode == 0 ? 2 : (this.coordBaseMode == 1 ? 1 : (this.coordBaseMode == 2 ? 3 : 0));
        this.placeBlockAtCurrentPosition(world, Blocks.stone_stairs, stairMeta, 4, 0, 0, box);
        this.fillWithBlocks(world, box, 1, 1, 3, 1, 4, 3, (Block)IEContent.blockTreatedWood, (Block)IEContent.blockTreatedWood, false);
        this.fillWithBlocks(world, box, 1, 1, 8, 1, 6, 8, (Block)IEContent.blockTreatedWood, (Block)IEContent.blockTreatedWood, false);
        this.fillWithBlocks(world, box, 9, 1, 3, 9, 6, 3, (Block)IEContent.blockTreatedWood, (Block)IEContent.blockTreatedWood, false);
        this.fillWithBlocks(world, box, 9, 1, 8, 9, 6, 8, (Block)IEContent.blockTreatedWood, (Block)IEContent.blockTreatedWood, false);
        this.fillWithBlocks(world, box, 1, 4, 3, 9, 4, 8, (Block)IEContent.blockTreatedWood, (Block)IEContent.blockTreatedWood, false);
        this.fillWithBlocks(world, box, 6, 5, 3, 6, 7, 3, (Block)IEContent.blockTreatedWood, (Block)IEContent.blockTreatedWood, false);
        this.fillWithBlocks(world, box, 1, 5, 5, 1, 6, 5, (Block)IEContent.blockTreatedWood, (Block)IEContent.blockTreatedWood, false);
        this.fillWithBlocks(world, box, 2, 4, 5, 8, 4, 7, Blocks.air, Blocks.air, false);
        this.fillWithMetadataBlocks(world, box, 2, 0, 3, 5, 0, 4, Blocks.wool, 13, Blocks.wool, 13, false);
        this.fillWithMetadataBlocks(world, box, 2, 0, 4, 8, 0, 7, Blocks.wool, 13, Blocks.wool, 13, false);
        this.fillWithMetadataBlocks(world, box, 6, 4, 4, 8, 4, 4, Blocks.wool, 13, Blocks.wool, 13, false);
        this.fillWithMetadataBlocks(world, box, 2, 4, 5, 7, 4, 5, Blocks.wool, 13, Blocks.wool, 13, false);
        this.fillWithMetadataBlocks(world, box, 2, 4, 6, 6, 4, 6, Blocks.wool, 13, Blocks.wool, 13, false);
        this.fillWithMetadataBlocks(world, box, 2, 4, 7, 4, 4, 7, Blocks.wool, 13, Blocks.wool, 13, false);
        this.fillWithBlocks(world, box, 2, 1, 3, 8, 3, 3, Blocks.planks, Blocks.planks, false);
        this.fillWithBlocks(world, box, 7, 5, 3, 8, 6, 3, Blocks.planks, Blocks.planks, false);
        this.placeBlockAtCurrentPosition(world, Blocks.planks, 0, 7, 7, 3, box);
        this.fillWithBlocks(world, box, 6, 5, 4, 6, 7, 4, Blocks.planks, Blocks.planks, false);
        this.fillWithBlocks(world, box, 2, 5, 5, 5, 6, 5, Blocks.planks, Blocks.planks, false);
        this.fillWithBlocks(world, box, 3, 7, 5, 5, 7, 5, Blocks.planks, Blocks.planks, false);
        this.placeBlockAtCurrentPosition(world, Blocks.planks, 0, 5, 8, 5, box);
        this.fillWithBlocks(world, box, 2, 1, 8, 8, 3, 8, Blocks.planks, Blocks.planks, false);
        this.fillWithBlocks(world, box, 2, 5, 8, 8, 6, 8, Blocks.planks, Blocks.planks, false);
        this.fillWithBlocks(world, box, 3, 7, 8, 7, 7, 8, Blocks.planks, Blocks.planks, false);
        this.placeBlockAtCurrentPosition(world, Blocks.planks, 0, 5, 8, 8, box);
        this.fillWithBlocks(world, box, 1, 1, 4, 1, 3, 7, Blocks.planks, Blocks.planks, false);
        this.fillWithBlocks(world, box, 1, 5, 6, 1, 5, 7, Blocks.planks, Blocks.planks, false);
        this.fillWithBlocks(world, box, 9, 1, 4, 9, 3, 7, Blocks.planks, Blocks.planks, false);
        this.fillWithBlocks(world, box, 9, 5, 4, 9, 6, 7, Blocks.planks, Blocks.planks, false);
        this.placeBlockAtCurrentPosition(world, Blocks.glass_pane, 0, 2, 2, 3, box);
        this.placeBlockAtCurrentPosition(world, Blocks.glass_pane, 0, 6, 2, 3, box);
        this.placeBlockAtCurrentPosition(world, Blocks.glass_pane, 0, 8, 2, 3, box);
        this.fillWithBlocks(world, box, 7, 6, 3, 8, 6, 3, Blocks.glass_pane, Blocks.glass_pane, false);
        this.fillWithBlocks(world, box, 3, 2, 8, 5, 2, 8, Blocks.glass_pane, Blocks.glass_pane, false);
        this.fillWithBlocks(world, box, 3, 6, 8, 4, 6, 8, Blocks.glass_pane, Blocks.glass_pane, false);
        this.fillWithBlocks(world, box, 6, 6, 8, 7, 6, 8, Blocks.glass_pane, Blocks.glass_pane, false);
        this.fillWithBlocks(world, box, 1, 2, 5, 1, 2, 6, Blocks.glass_pane, Blocks.glass_pane, false);
        this.fillWithBlocks(world, box, 1, 6, 6, 1, 6, 7, Blocks.glass_pane, Blocks.glass_pane, false);
        this.fillWithBlocks(world, box, 9, 2, 5, 9, 2, 6, Blocks.glass_pane, Blocks.glass_pane, false);
        this.fillWithBlocks(world, box, 9, 6, 5, 9, 6, 6, Blocks.glass_pane, Blocks.glass_pane, false);
        this.fillWithMetadataBlocks(world, box, 1, 1, 1, 1, 1, 2, (Block)IEContent.blockWoodenDecoration, 1, (Block)IEContent.blockWoodenDecoration, 1, false);
        this.fillWithMetadataBlocks(world, box, 2, 1, 1, 3, 1, 1, (Block)IEContent.blockWoodenDecoration, 1, (Block)IEContent.blockWoodenDecoration, 1, false);
        this.fillWithMetadataBlocks(world, box, 5, 1, 1, 5, 1, 2, (Block)IEContent.blockWoodenDecoration, 1, (Block)IEContent.blockWoodenDecoration, 1, false);
        this.fillWithMetadataBlocks(world, box, 1, 5, 3, 1, 5, 4, (Block)IEContent.blockWoodenDecoration, 1, (Block)IEContent.blockWoodenDecoration, 1, false);
        this.fillWithMetadataBlocks(world, box, 2, 5, 3, 5, 5, 3, (Block)IEContent.blockWoodenDecoration, 1, (Block)IEContent.blockWoodenDecoration, 1, false);
        this.fillWithMetadataBlocks(world, box, 7, 1, 6, 7, 5, 6, (Block)IEContent.blockWoodenDecoration, 1, (Block)IEContent.blockWoodenDecoration, 1, false);
        int doorMeta = this.coordBaseMode == 0 ? 1 : (this.coordBaseMode == 1 ? 2 : (this.coordBaseMode == 2 ? 3 : 0));
        this.placeDoorAtCurrentPosition(world, box, rand, 4, 1, 3, doorMeta);
        if (this.coordBaseMode == 0 || this.coordBaseMode == 1) {
            this.placeDoorAtCurrentPosition(world, box, rand, 4, 5, 5, doorMeta);
            this.placeDoorAtCurrentPosition(world, box, rand, 3, 5, 5, doorMeta);
        } else {
            this.placeDoorAtCurrentPosition(world, box, rand, 3, 5, 5, doorMeta);
            this.placeDoorAtCurrentPosition(world, box, rand, 4, 5, 5, doorMeta);
        }
        this.placeLantern(world, box, 5, 3, 6, 0);
        this.placeLantern(world, box, 5, 7, 6, 0);
        this.placeBlockAtCurrentPosition(world, Blocks.oak_stairs, stairMeta, 8, 1, 6, box);
        stairMeta = this.getMetadataWithOffset(Blocks.oak_stairs, 1);
        this.placeBlockAtCurrentPosition(world, Blocks.planks, 0, 8, 1, 7, box);
        this.placeBlockAtCurrentPosition(world, Blocks.oak_stairs, stairMeta, 7, 2, 7, box);
        this.placeBlockAtCurrentPosition(world, Blocks.oak_stairs, stairMeta, 6, 3, 7, box);
        this.placeBlockAtCurrentPosition(world, Blocks.oak_stairs, stairMeta, 5, 4, 7, box);
        this.fillWithMetadataBlocks(world, box, 0, 6, 4, 0, 6, 8, (Block)Blocks.stone_slab, 12, (Block)Blocks.stone_slab, 12, false);
        this.fillWithMetadataBlocks(world, box, 1, 7, 4, 1, 7, 8, (Block)Blocks.stone_slab, 4, (Block)Blocks.stone_slab, 4, false);
        this.fillWithMetadataBlocks(world, box, 3, 8, 4, 3, 8, 8, (Block)Blocks.stone_slab, 4, (Block)Blocks.stone_slab, 4, false);
        this.fillWithMetadataBlocks(world, box, 5, 9, 2, 5, 9, 8, (Block)Blocks.stone_slab, 4, (Block)Blocks.stone_slab, 4, false);
        this.fillWithMetadataBlocks(world, box, 7, 8, 2, 7, 8, 8, (Block)Blocks.stone_slab, 4, (Block)Blocks.stone_slab, 4, false);
        this.fillWithMetadataBlocks(world, box, 9, 7, 2, 9, 7, 8, (Block)Blocks.stone_slab, 4, (Block)Blocks.stone_slab, 4, false);
        this.fillWithMetadataBlocks(world, box, 10, 6, 2, 10, 6, 8, (Block)Blocks.stone_slab, 12, (Block)Blocks.stone_slab, 12, false);
        stairMeta = this.getMetadataWithOffset(Blocks.oak_stairs, 0);
        this.fillWithMetadataBlocks(world, box, 2, 7, 4, 2, 7, 8, Blocks.brick_stairs, stairMeta, Blocks.brick_stairs, stairMeta, false);
        this.fillWithMetadataBlocks(world, box, 4, 8, 4, 4, 8, 8, Blocks.brick_stairs, stairMeta, Blocks.brick_stairs, stairMeta, false);
        stairMeta = this.getMetadataWithOffset(Blocks.oak_stairs, 1);
        this.fillWithMetadataBlocks(world, box, 6, 8, 2, 6, 8, 8, Blocks.brick_stairs, stairMeta, Blocks.brick_stairs, stairMeta, false);
        this.fillWithMetadataBlocks(world, box, 8, 7, 2, 8, 7, 8, Blocks.brick_stairs, stairMeta, Blocks.brick_stairs, stairMeta, false);
        this.fillWithBlocks(world, box, 2, 7, 5, 2, 8, 5, Blocks.brick_block, Blocks.brick_block, false);
        this.fillWithBlocks(world, box, 7, 8, 4, 7, 9, 4, Blocks.brick_block, Blocks.brick_block, false);
        try {
            this.placeCrate(world, box, rand, 6, 0, 1, crateContents.getItems(rand), 2 + rand.nextInt(4));
            this.placeCrate(world, box, rand, 8, 0, 2, crateContents.getItems(rand), 2 + rand.nextInt(4));
            this.placeCrate(world, box, rand, 5, 1, 7, crateContents.getItems(rand), 2 + rand.nextInt(4));
            int side = this.coordBaseMode == 0 ? 2 : (this.coordBaseMode == 1 ? 3 : (this.coordBaseMode == 2 ? 0 : 1));
            this.placeItemframe(rand, world, 4, 3, 3, side, new ItemStack((Item)IEContent.itemTool, 1, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.spawnVillagers(world, box, 4, 1, 2, 1);
        return true;
    }

    protected boolean placeCrate(World world, StructureBoundingBox box, Random rand, int x, int y, int z, WeightedRandomChestContent[] contents, int amount) {
        int k1;
        int j1;
        int i1 = this.getXWithOffset(x, z);
        if (box.isVecInside(i1, j1 = this.getYWithOffset(y), k1 = this.getZWithOffset(x, z)) && (world.getBlock(i1, j1, k1) != IEContent.blockWoodenDevice || world.getBlockMetadata(i1, j1, k1) != 4)) {
            world.setBlock(i1, j1, k1, (Block)IEContent.blockWoodenDevice, 4, 2);
            TileEntity tile = world.getTileEntity(i1, j1, k1);
            if (tile instanceof TileEntityWoodenCrate) {
                WeightedRandomChestContent.generateChestContents((Random)rand, (WeightedRandomChestContent[])contents, (IInventory)((TileEntityWoodenCrate)tile), (int)amount);
            }
            return true;
        }
        return false;
    }

    protected boolean placeLantern(World world, StructureBoundingBox box, int x, int y, int z, int facing) {
        int k1;
        int j1;
        int i1 = this.getXWithOffset(x, z);
        if (box.isVecInside(i1, j1 = this.getYWithOffset(y), k1 = this.getZWithOffset(x, z))) {
            world.setBlock(i1, j1, k1, (Block)IEContent.blockMetalDecoration, 2, 2);
            TileEntity tile = world.getTileEntity(i1, j1, k1);
            if (tile instanceof TileEntityLantern) {
                ((TileEntityLantern)tile).facing = facing;
            }
            return true;
        }
        return false;
    }

    public void placeItemframe(Random random, World world, int x, int y, int z, int side, ItemStack stack) {
        int i1 = this.getXWithOffset(x, z);
        int j1 = this.getYWithOffset(y);
        int k1 = this.getZWithOffset(x, z);
        EntityItemFrame e = new EntityItemFrame(world, i1, j1, k1, side);
        e.setDisplayedItem(stack);
        if (e.onValidSurface() && world.getEntitiesWithinAABB(EntityHanging.class, AxisAlignedBB.getBoundingBox((double)((double)i1 - 0.125), (double)j1, (double)((double)k1 - 0.125), (double)((double)i1 + 1.125), (double)(j1 + 1), (double)((double)k1 + 1.125))).isEmpty() && !world.isRemote) {
            world.spawnEntityInWorld((Entity)e);
        }
    }

    protected int getVillagerType(int i) {
        return Config.getInt("villager_engineer");
    }

    static {
        framesHung = new ArrayList<ChunkCoordinates>();
    }

    public static class VillageManager
    implements VillagerRegistry.IVillageCreationHandler {
        public Object buildComponent(StructureVillagePieces.PieceWeight villagePiece, StructureVillagePieces.Start startPiece, List pieces, Random random, int p1, int p2, int p3, int p4, int p5) {
            StructureBoundingBox box = StructureBoundingBox.getComponentToAddBoundingBox((int)p1, (int)p2, (int)p3, (int)0, (int)0, (int)0, (int)11, (int)10, (int)9, (int)p4);
            return !VillageEngineersHouse.canVillageGoDeeper((StructureBoundingBox)box) || StructureComponent.findIntersecting((List)pieces, (StructureBoundingBox)box) != null ? null : new VillageEngineersHouse(startPiece, p5, random, box, p4);
        }

        public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random random, int i) {
            return new StructureVillagePieces.PieceWeight(VillageEngineersHouse.class, 15, MathHelper.getRandomIntegerInRange((Random)random, (int)(0 + i), (int)(1 + i)));
        }

        public Class<?> getComponentClass() {
            return VillageEngineersHouse.class;
        }
    }
}

