/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.network;

import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.entities.EntitySkylineHook;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;

public class MessageSkyhookSync
implements IMessage {
    int entityID;
    ImmersiveNetHandler.Connection connection;
    ChunkCoordinates target;
    Vec3[] subPoints;
    int targetPoint;

    public MessageSkyhookSync(EntitySkylineHook entity) {
        this.entityID = entity.getEntityId();
        this.connection = entity.connection;
        this.target = entity.target;
        this.subPoints = entity.subPoints;
        this.targetPoint = entity.targetPoint;
    }

    public MessageSkyhookSync() {
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.connection = ImmersiveNetHandler.Connection.readFromNBT(tag);
        this.target = new ChunkCoordinates(buf.readInt(), buf.readInt(), buf.readInt());
        int l = buf.readInt();
        this.subPoints = new Vec3[l];
        for (int i = 0; i < l; ++i) {
            this.subPoints[i] = Vec3.createVectorHelper((double)buf.readDouble(), (double)buf.readDouble(), (double)buf.readDouble());
        }
        this.targetPoint = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.connection.writeToNBT());
        buf.writeInt(this.target.posX);
        buf.writeInt(this.target.posY);
        buf.writeInt(this.target.posZ);
        buf.writeInt(this.subPoints.length);
        for (Vec3 v : this.subPoints) {
            buf.writeDouble(v.xCoord);
            buf.writeDouble(v.yCoord);
            buf.writeDouble(v.zCoord);
        }
        buf.writeInt(this.targetPoint);
    }

    public static class Handler
    implements IMessageHandler<MessageSkyhookSync, IMessage> {
        public IMessage onMessage(MessageSkyhookSync message, MessageContext ctx) {
            Entity ent = ClientUtils.mc().theWorld.getEntityByID(message.entityID);
            if (ent instanceof EntitySkylineHook) {
                ((EntitySkylineHook)ent).connection = message.connection;
                ((EntitySkylineHook)ent).target = message.target;
                ((EntitySkylineHook)ent).subPoints = message.subPoints;
                ((EntitySkylineHook)ent).targetPoint = message.targetPoint;
            }
            return null;
        }
    }
}

